@extends('layouts.front')
@push('css')
    <style>
            body {
            font-family: Jost;
                color: #111;
            }
        /* Responsive location and name input row */
        .location-name-row {
            display: flex;
            gap: 0.5rem;
        }
        @media (max-width: 991.98px) {
            .location-name-row {
                flex-direction: column;
                gap: 0.75rem;
            }
            .location-name-row > * {
                width: 100% !important;
                min-width: 0 !important;
            }
        }
       
        /* Fix select dropdown vertical cut-off issue */
        .search-filter-row select.form-control {
            padding-bottom: 8px;
            min-height: 38px;
            line-height: 1.5;
        }
        .btn-outline-primary {
            color: #3c3635;
            background-color: #fff;
            border-color: #e3dbd9;
            -webkit-transition: 0.2s ease-in;
            -o-transition: 0.2s ease-in;
            transition: 0.2s ease-in;
        }

        .btn-outline-primary:hover,
        .btn-outline-primary:focus,
        .btn-outline-primary.focus {
            background: #0d6efd;
            color: #fff;
            border-color: #0d6efd;
        }

        .property-type-container {
            position: relative;
        }

        .property-type-toggle {
            position: relative;
            padding: 8px 12px;
        }

        .property-type-options {
            position: absolute;
            width: 100%;
            z-index: 1000;
        }

        input[type="checkbox"]:checked+label {
            background-color: #0d6efd;
            color: white;
        }

        /* Responsive filter row */
        .search-filter-row {
            gap: 0.5rem;
        }
        @media (max-width: 991.98px) {
            .search-filter-row {
                flex-wrap: wrap;
            }
            .search-filter-row > * {
                flex: 1 1 48%;
                min-width: 140px;
                margin-bottom: 8px;
            }
            .search-filter-row .position-relative {
                min-width: 140px !important;
            }
        }
        @media (max-width: 767.98px) {
            .search-filter-row {
                flex-direction: column;
                gap: 0.75rem;
            }
            .search-filter-row > * {
                width: 100% !important;
                min-width: 0 !important;
                margin-bottom: 0;
            }
            .search-filter-row .position-relative {
                width: 100% !important;
                min-width: 0 !important;
            }
        }
        select.form-control {
            appearance: none; /* removes default OS styling */
            -webkit-appearance: none;
            -moz-appearance: none;
            background: url('data:image/svg+xml;utf8,<svg fill="%23666" height="16" viewBox="0 0 24 24" width="16" xmlns="http://www.w3.org/2000/svg"><path d="M7 10l5 5 5-5z"/></svg>') no-repeat right 0.75rem center/1rem auto;
            padding-right: 2rem; /* add space for the icon */
            background-color: #fff; /* or match your design */
        }
    </style>
@endpush
@section('content')
    <div class="container">
      <div class="row">
            <div class="col-lg-12 col-md-12">
                <div class="filter_search_opt">
                    <a id="toogle-sm-sidebar-btn" href="javascript:void(0);">@lang('Search Property')&nbsp;&nbsp; <i
                            class="ti-menu"></i></a>
                </div>
            </div>
        </div>
        <!-- Search Form -->
        <div class="">
            <div class="hero-search-content">
                <form id="search-form" action="" method="GET">
                    <div class="row g-2 mt-3">
                        <div class="location-name-row mb-2">
                            <div>
                                <select id="location1" class="form-control" name="location_id">
                                    <option value="">&nbsp;Select City</option>
                                    <optgroup label="Top Cities">
                                        @foreach ($locations->where('is_top_city', 1) as $data)
                                            <option value="{{ $data->id }}"
                                                {{ request()->location_id == $data->id ? 'selected' : '' }}>
                                                {{ $data->name }}
                                            </option>
                                        @endforeach
                                    </optgroup>
                                    <optgroup label="Other Cities">
                                        @foreach ($locations->where('is_top_city', 0) as $data)
                                            <option value="{{ $data->id }}"
                                                {{ request()->location_id == $data->id ? 'selected' : '' }}>
                                                {{ $data->name }}
                                            </option>
                                        @endforeach
                                    </optgroup>
                                </select>
                            </div>
                            <div style="flex:2;min-width:180px;">
                                <div class="input-group w-100">
                                    <span class="input-group-text d-none d-sm-flex"><i class="fa fa-search"></i></span>
                                    <input id="locality-search" type="text" class="form-control small-input" name="name"
                                        value="{{ old('name', request()->name) }}" placeholder="@lang('Search for locality, landmark, project, or builder')">
                                </div>
                                <div id="suggestions"></div>
                            </div>
                        </div>
                        <div class="search-filter-row d-flex flex-row align-items-center w-100 mb-2">
                        <div id="search-form-collapsible" class="search-filter-row d-flex flex-row align-items-center w-100 mb-2">
                            <select name="gender" class="form-control w-auto">
                                <option value="">Gender</option>
                                <option value="girls" {{ request()->gender == 'girls' ? 'selected' : '' }}>Girls Only</option>
                                <option value="boys" {{ request()->gender == 'boys' ? 'selected' : '' }}>Boys Only</option>
                                <option value="both" {{ request()->gender == 'both' ? 'selected' : '' }}>Both</option>
                            </select>
                           <select name="room_type" class="form-control">
                                <option value="">Room Type</option>
                                <option value="Private Room" {{ request()->room_type == 'Private Room' ? 'selected' : '' }}>Private Room</option>
                                <option value="Double Sharing" {{ request()->room_type == 'Double Sharing' ? 'selected' : '' }}>Double Sharing</option>
                                <option value="Triple Sharing" {{ request()->room_type == 'Triple Sharing' ? 'selected' : '' }}>Triple Sharing</option>
                                <option value="3+ Sharing" {{ request()->room_type == '3+ Sharing' ? 'selected' : '' }}>3+ Sharing</option>
                            </select>
                           
                            <div class="position-relative w-100" >
                                <button type="button" class="form-select d-flex align-items-center justify-content-between" id="priceToggleBtn">
@php
    $minPriceLabel = '0';
    $maxPriceLabel = '20,000+';
    $showPlusKeyword = true;
    if(request()->has('minPrice') || request()->has('maxPrice')) {
        $minPriceLabel = request()->minPrice ? number_format(request()->minPrice) : '0';
        $maxVal = request()->maxPrice;
        if($maxVal !== null && $maxVal < 20000) {
            $maxPriceLabel = number_format($maxVal);
            $showPlusKeyword = false;
        } else if($maxVal !== null && $maxVal >= 20000) {
            $maxPriceLabel = '20,000+';
            $showPlusKeyword = false;
        }
        if(request()->has('minPrice') && !request()->has('maxPrice')) {
            $showPlusKeyword = false;
        }
    }
@endphp
<span>₹<span id="minPriceValue">{{ $minPriceLabel }}</span> - ₹<span id="maxPriceValue">{{ $maxPriceLabel }}</span></span>
                                </button>
                                <div id="priceRangeContainer" class="bg-white p-3 border rounded shadow-sm RangeContainer" style="display: none;">
                                    <div class="d-flex justify-content-between">
                                        <span>₹0</span>
                                        <span>₹20,000+</span>
                                    </div>
                                    <div class="range-slider-wrapper">
                                        <input type="range" id="minRange" name="minPrice" min="0" max="20000" step="500" value="{{ request()->minPrice ?? 0 }}" oninput="updateSlider()">
                                        <input type="range" id="maxRange" name="maxPrice" min="0" max="20000" step="500" value="{{ (request()->maxPrice ?? 20000) > 20000 ? 20000 : (request()->maxPrice ?? 20000) }}" oninput="updateSlider()">
                                        <div class="slider-track">
                                            <div class="fill-track"></div>
                                        </div>
                                    </div>
                                    <div class="small  text-center">
                                        ₹<span id="selectedMinPrice">{{ request()->minPrice ? number_format(request()->minPrice) : '0' }}</span> - ₹<span id="selectedMaxPrice">{{ (request()->maxPrice ?? 20000) >= 20000 ? '20,000+' : number_format(request()->maxPrice ?? 20000) }}</span>
                                    </div>
                                </div>
                            </div>
                             <select name="meals_available" class="form-control w-auto">
                                <option value="">Food Available</option>
                                <option value="yes" {{ request()->meals_available == 'yes' ? 'selected' : '' }}>Yes</option>
                                <option value="no" {{ request()->meals_available == 'no' ? 'selected' : '' }}>No</option>
                            </select>
                            <select name="amenities" class="form-control w-auto">
                                <option value="">Amenities</option>
                                <option value="ac" {{ request()->amenities == 'ac' ? 'selected' : '' }}>AC</option>
                                <option value="tv_in_room" {{ request()->amenities == 'tv_in_room' ? 'selected' : '' }}>TV in room</option>
                                <option value="personal_cupboard" {{ request()->amenities == 'personal_cupboard' ? 'selected' : '' }}>Personal Cupboard</option>
                                <option value="table_chair" {{ request()->amenities == 'table_chair' ? 'selected' : '' }}>Table Chair</option>
                                <option value="attached_balcony" {{ request()->amenities == 'attached_balcony' ? 'selected' : '' }}>Attached Balcony</option>
                                <option value="attached_bathroom" {{ request()->amenities == 'attached_bathroom' ? 'selected' : '' }}>Attached Bathroom</option>
                            </select>
                            <input type="hidden" name="type" value="{{ request()->type }}">
                            <button type="submit" class="btn btn-primary btn-sm rounded border-primary px-4">Search</button>
                            <button id="clearBtn" class="btn btn-secondary btn-sm rounded border-secondary px-4 mx-1">Clear</button>
                        </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="col-lg-12 col-md-12">
            <h4 class="ipt-title mt-2">
                Properties for PG in,
                @if (request()->name)
                    {{ request()->name }},
                @endif
                @php
                    $locationName = $locations->where('id', request()->location_id)->first()->name ?? '';
                @endphp
                {{ $locationName }}
            </h4>
            <p class=" small">
                Showing {{ $properties->firstItem() }} to {{ $properties->lastItem() }} of {{ $properties->total() }}
                results
            </p><br>
        </div>
        <div class="row my-4">
            <div class="col-lg-12 col-md-12 col-md-12 list-layout">
                <div class="row">
                    <div class="col-lg-12 col-md-12">
                        <div class="filter-fl">
                            <h4>@lang('Search Results')</h4>
                        </div>
                        <hr>
                    </div>
                    @includeIf('partials.front.pg-property', ['properties' => $topSlotProperties, 'isSponsored' => true])
                    @includeIf('partials.front.pg-property', ['properties' => $mediumSlotProperties, 'isSponsored' => true])
                    @includeIf('partials.front.pg-property', ['properties' => $properties, 'isSponsored' => false])
                    {{-- @includeIf('partials.front.pg-property') --}}
                </div>
            </div>
        </div>
    </div>
    @includeIf('partials.front.cta')
@endsection
@push('js')
    <script src="{{ asset('assets/front/js/map_infobox.js') }}"></script>
    <script src="{{ asset('assets/front/js/markerclusterer.js') }}"></script>
    <script src="{{ asset('assets/front/js/map.js') }}"></script>
    <script>
        // Mobile toggle for filter row
        $(document).ready(function() {
            $('#toogle-sm-sidebar-btn').on('click', function() {
                $('#search-form-collapsible').toggleClass('active');
            });
        });
        $(document).ready(function() {
            // Slugify function
            function slugify(text) {
                return text.toString().toLowerCase().replace(/\s+/g, '-')
                    .replace(/[^\w\-]+/g, '')
                    .replace(/\-\-+/g, '-')
                    .replace(/^-+/, '')
                    .replace(/-+$/, '');
            }
            // Search icon click triggers form submit
            $(".input-group-text").on("click", function() {
                $("#search-form").trigger("submit");
            });

            // Pretty URL submit logic
            $("#search-form").on("submit", function(e) {
                e.preventDefault();
                var cityText = $('#location1 option:selected').text() || '';
                var cityId = $('#location1').val() || '';
                var citySlug = cityText ? slugify(cityText) : 'CITY_PLACEHOLDER';
                var keyword = $('#locality-search').val().trim();
                var localitySlug = keyword ? slugify(keyword) : citySlug;
                var baseUrl = "{{ url('/in') }}";
                var actionUrl = baseUrl + '/paying-guests/pgs-in-' + localitySlug + '-in-' + 
                    citySlug;

                // Create a dynamic form for GET
                var $form = $('<form>', {
                    method: 'GET',
                    action: actionUrl
                });
                // Add fields you want to pass to controller
                $form.append($('<input>', {
                    type: 'hidden',
                    name: 'location_id',
                    value: cityId
                }));
                $form.append($('<input>', {
                    type: 'hidden',
                    name: 'name',
                    value: keyword
                }));
                // Add all selected category_id[] checkboxes
                $("#search-form input[name='category_id[]']:checked").each(function() {
                    $form.append($('<input>', {
                        type: 'hidden',
                        name: 'category_id[]',
                        value: $(this).val()
                    }));
                });
                // Add all other fields from the original form (except category_id[] and _token)
                $("#search-form input, #search-form select").not('[name="_token"], [name="category_id[]"]')
                    .each(function() {
                        var $el = $(this);
                        var name = $el.attr('name');
                        var value = $el.val();
                        if (name && value && !$form.find('[name="' + name + '"]')[0]) {
                            $form.append($('<input>', {
                                type: 'hidden',
                                name: name,
                                value: value
                            }));
                        }
                    });
                $form.appendTo('body').submit();
            });
            // Price range dropdown open/close
            $('#priceToggleBtn').on('click', function(e) {
                e.stopPropagation();
                var priceRangeContainer = $('#priceRangeContainer');
                priceRangeContainer.css('display', 'block');
            });
            $(document).on('click', function(e) {
                var priceRangeContainer = $('#priceRangeContainer');
                var priceButton = $('#priceToggleBtn');
                if (!$(e.target).closest('#priceRangeContainer, #priceToggleBtn').length) {
                    priceRangeContainer.css('display', 'none');
                }
            });
            // Range slider update logic
            function formatINR(number) {
                return new Intl.NumberFormat('en-IN').format(number);
            }

            function updateSlider() {
                var minSlider = $('#minRange');
                var maxSlider = $('#maxRange');
                var fillTrack = $('.fill-track');
                var min = parseInt(minSlider.val());
                var max = parseInt(maxSlider.val());
                if (min > max) {
                    var temp = min;
                    min = max;
                    max = temp;
                    minSlider.val(min);
                    maxSlider.val(max);
                }
                var range = 20000;
                var minPercent = (min / range) * 100;
                var maxPercent = (max / range) * 100;
                fillTrack.css('left', minPercent + '%');
                fillTrack.css('width', (maxPercent - minPercent) + '%');
                // Update visible price labels
                var maxDisplay = max >= 20000 ? '20,000+' : formatINR(max);
                $('#selectedMinPrice').text(formatINR(min));
                $('#selectedMaxPrice').text(maxDisplay);
                $('#minPriceValue').text(formatINR(min));
                $('#maxPriceValue').text(maxDisplay);
            }
            $('#minRange, #maxRange').on('input', updateSlider);
            updateSlider();

            // Restore filter values from request (after submit)
            function setFilterValuesFromRequest() {
                // City
                var cityId = '{{ request()->location_id ?? '' }}';
                if (cityId) $('#location1').val(cityId);
                // Locality
                var locality = '{{ request()->name ?? '' }}';
                if (locality) $('#locality-search').val(locality);
                // BHK
                var bhk = '{{ request()->no_of_bhk ?? '' }}';
                if (bhk) $('select[name="no_of_bhk"]').val(bhk);
                // Sale Type
                var saleType = '{{ request()->sale_type ?? '' }}';
                if (saleType) $('select[name="sale_type"]').val(saleType);
                // Construction Status
                var cs = '{{ request()->construction_status ?? '' }}';
                if (cs) $('select[name="construction_status"]').val(cs);
                // Category checkboxes
                var cats = @json(request()->category_id ?? []);
                $('input[name="category_id[]"]').prop('checked', false);
                cats.forEach(function(catId) {
                    $('input[name="category_id[]"][value="' + catId + '"]').prop('checked', true);
                });
                // Price Range
                var minPrice = '{{ request()->minPrice ?? '' }}';
                var maxPrice = '{{ request()->maxPrice ?? '' }}';
                if (minPrice) $('#minRange').val(minPrice);
                if (maxPrice) {
                    if (parseInt(maxPrice) >= 20000) {
                        $('#maxRange').val(20000);
                    } else {
                        $('#maxRange').val(maxPrice);
                    }
                }
                // Update slider visuals
                if (minPrice || maxPrice) updateSlider();
            }
            setFilterValuesFromRequest();

            // Clear button logic
            $('#clearBtn').on('click', function(e) {
                e.preventDefault();
                // Reset all select fields except location
                $('#search-form select').not('#location1').each(function() {
                    $(this).val('');
                });
                // Reset all text inputs
                $('#search-form input[type="text"]').val('');
                // Reset all hidden fields except CSRF
                $('#search-form input[type="hidden"]').not('[name="_token"]').val('');
                // Reset all checkboxes
                $('#search-form input[type="checkbox"]').prop('checked', false);
                // Reset price range
                $('#minRange').val(0);
                $('#maxRange').val(20000);
            updateSlider();

            // Retain selected price range after filter
            $('#minRange, #maxRange').on('change', function() {
                var minVal = $('#minRange').val();
                var maxVal = $('#maxRange').val();
                $('#minPriceValue').text(formatINR(minVal));
                $('#maxPriceValue').text(formatINR(maxVal));
                $('#selectedMinPrice').text(formatINR(minVal));
                $('#selectedMaxPrice').text(formatINR(maxVal));
            });
                // Reset suggestions if any
                $('#suggestions').empty();
            });

            $('.property-type-options').each(function() {
                const $options = $(this);

                // On mouse leave, collapse the corresponding section
                $options.on('mouseleave', function() {
                    const collapseContainer = $options.closest('.collapse');
                    const collapse = bootstrap.Collapse.getInstance(collapseContainer[0]);

                    if (collapse && collapseContainer.hasClass('show')) {
                        collapse.hide();
                    }
                });

                 // On change of checkbox inside, collapse after small delay
                $options.find('input[type="checkbox"]').on('change', function() {
                    const collapseContainer = $(this).closest('.collapse');
                    const collapse = bootstrap.Collapse.getInstance(collapseContainer[0]);

                    if (collapse && collapseContainer.hasClass('show')) {
                        setTimeout(() => collapse.hide(), 200);
                    }
                });
            });

        });
         $(document).on('click', '#wishList', function() {
        let $this = $(this);
        let propertyId = $this.data('property');
        let userId = $this.data('user');

        if (!userId) {
            window.location.href = mainurl + '/login-register';
            return;
        }
        console.log("Wishlist Clicked!");

        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            method: "POST",
            url: mainurl + '/property/wishlist',
            data: {
                property_id: propertyId,
                user_id: userId
            },
            success: function(data) {
                if (data.success) {
                    $this.removeClass().addClass('like-bitt add-to-favorite');
                    toastr.success(data.success);
                } else {
                    $this.removeClass().addClass('add-to-favorite');
                    toastr.error(data.error);
                }
                setTimeout(() => {
                    location.reload();
                }, 1000);
            }
        });
    });
    </script>
@endpush
