@extends('layouts.front')
@push('css')
    <style>
        .btn-outline-primary {
            color: #3c3635;
            background-color: #fff;
            border-color: #e3dbd9;
            -webkit-transition: 0.2s ease-in;
            -o-transition: 0.2s ease-in;
            transition: 0.2s ease-in;
        }

        .btn-outline-primary:hover,
        .btn-outline-primary:focus,
        .btn-outline-primary.focus {
            background: #0d6efd;
            color: #fff;
            border-color: #0d6efd;
        }

        .property-type-container {
            position: relative;
        }

        .property-type-toggle {
            position: relative;
            padding: 8px 12px;
        }

        .property-type-options {
            position: absolute;
            width: auto;
            z-index: 1000;
        }

        input[type="checkbox"]:checked+label {
            background-color: #0d6efd;
            color: white;
        }
    </style>
@endpush
@section('content')
    <div class="container">
        <div class="row">
            <div class="col-lg-12 col-md-12">
                <div class="filter_search_opt">
                    <a id="toogle-sm-sidebar-btn" href="javascript:void(0);">@lang('Search Property')&nbsp;&nbsp; <i
                            class="ti-menu"></i></a>
                </div>
            </div>
        </div>
        <!-- Search Form -->
        <div class="">
            <div class="hero-search-content">
                <form id="search-form" action="" method="GET">
                    <div class="row g-2 mt-3">
                        <div class="col-lg-2 my-2">
                            <select id="location1" class="form-control" name="location_id">
                                <option value="">&nbsp;Select City</option>
                                <optgroup label="Top Cities">
                                    @foreach ($locations->where('is_top_city', 1) as $data)
                                        <option value="{{ $data->id }}"
                                            {{ request()->location_id == $data->id ? 'selected' : '' }}>
                                            {{ $data->name }}
                                        </option>
                                    @endforeach
                                </optgroup>
                                <optgroup label="Other Cities">
                                    @foreach ($locations->where('is_top_city', 0) as $data)
                                        <option value="{{ $data->id }}"
                                            {{ request()->location_id == $data->id ? 'selected' : '' }}>
                                            {{ $data->name }}
                                        </option>
                                    @endforeach
                                </optgroup>
                            </select>
                        </div>
                        <div class="col-12 col-sm-8 col-lg-10">
                            <div class="input-group w-100">
                                <span class="input-group-text d-none d-sm-flex"><i class="fa fa-search"></i></span>
                                <input id="locality-search" type="text" class="form-control small-input" name="name"
                                    value="{{ old('name', request()->name) }}" placeholder="@lang('Search for locality, landmark, project, or builder')">
                            </div>
                            <div id="suggestions"></div>
                        </div>
                        <div class="col-lg-1">
                            <select class="form-select" name="no_of_bhk">
                                <option value="">BHK</option>
                                <option value="1-rk" {{ request()->no_of_bhk == '1-rk' ? 'selected' : '' }}>1 RK</option>
                                <option value="1-bhk" {{ request()->no_of_bhk == '1-bhk' ? 'selected' : '' }}>1 BHK
                                </option>
                                <option value="1.5-bhk" {{ request()->no_of_bhk == '1.5-bhk' ? 'selected' : '' }}>1.5 BHK
                                </option>
                                <option value="2-bhk" {{ request()->no_of_bhk == '2-bhk' ? 'selected' : '' }}>2 BHK
                                </option>
                                <option value="2.5-bhk" {{ request()->no_of_bhk == '2.5-bhk' ? 'selected' : '' }}>2.5 BHK
                                </option>
                                <option value="3-bhk" {{ request()->no_of_bhk == '3-bhk' ? 'selected' : '' }}>3 BHK
                                </option>
                                <option value="3.5-bhk" {{ request()->no_of_bhk == '3.5-bhk' ? 'selected' : '' }}>3.5 BHK
                                </option>
                                <option value="4-bhk" {{ request()->no_of_bhk == '4-bhk' ? 'selected' : '' }}>4 BHK
                                </option>
                                <option value="4.5-bhk" {{ request()->no_of_bhk == '4.5-bhk' ? 'selected' : '' }}>4.5 BHK
                                </option>
                                <option value="5-bhk" {{ request()->no_of_bhk == '5-bhk' ? 'selected' : '' }}>5 BHK
                                </option>
                                <option value="6-bhk" {{ request()->no_of_bhk == '6-bhk' ? 'selected' : '' }}>6 BHK
                                </option>
                                <option value="7+ bhk" {{ request()->no_of_bhk == '7+ bhk' ? 'selected' : '' }}>6+ BHK
                                </option>
                            </select>
                        </div>
                        <!-- Price Range -->
                        <div class="col-lg-3 position-relative">
                            <!-- Clickable Label to Toggle Price Range -->
                            <button type="button" class="form-select d-flex align-items-center justify-content-between"
                                id="priceToggleBtn">
                                <span>₹<span
                                        id="minPriceValue">{{ request()->minPrice ? number_format(request()->minPrice) : '0' }}</span>
                                    - ₹<span
                                        id="maxPriceValue">{{ request()->maxPrice ? number_format(request()->maxPrice) : '10,00,000' }}</span></span>
                            </button>
                            <!-- Price Range Dropdown -->
                            <div id="priceRangeContainer" class="bg-white p-3 border rounded shadow-sm RangeContainer"
                                style="display: none;">
                                <div class="d-flex justify-content-between">
                                    <span>₹0</span>
                                    <span>₹10,00,000+</span>
                                </div>
                                <!-- Dual-Handle Range Slider -->
                                <div class="range-slider-wrapper">
                                    <input type="range" id="minRange" name="minPrice" min="0" max="1000000"
                                        step="10000" value="{{ request()->minPrice ?? 0 }}" oninput="updateSlider()">
                                    <input type="range" id="maxRange" name="maxPrice" min="0" max="1000000"
                                        step="10000" value="{{ request()->maxPrice ?? 1000000 }}"
                                        oninput="updateSlider()">
                                    <div class="slider-track">
                                        <div class="fill-track"></div>
                                    </div>
                                </div>
                                <!-- Selected Price Display -->
                                <div class="small text-muted text-center">
                                    ₹<span
                                        id="selectedMinPrice">{{ request()->minPrice ? number_format(request()->minPrice) : '0' }}</span>
                                    - ₹<span
                                        id="selectedMaxPrice">{{ request()->maxPrice ? number_format(request()->maxPrice) : '10,00,000' }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-2">
                            <select class="form-select" name="user_type">
                                <option value="">Listed By</option>
                                <option value="agent" {{ request()->user_type == 'agent' ? 'selected' : '' }}>Agent
                                </option>
                                <option value="owner" {{ request()->user_type == 'owner' ? 'selected' : '' }}>Owner
                                </option>
                            </select>
                        </div>
                        <div class="col-lg-2">
                            <select class="form-select" name="furnish_type">
                                <option value="">Furnishing Status</option>
                                <option value="fully-furnished"
                                    {{ request()->furnish_type == 'fully-furnished' ? 'selected' : '' }}>Fully
                                    Furnished</option>
                                <option value="semi-furnished"
                                    {{ request()->furnish_type == 'semi-furnished' ? 'selected' : '' }}>Semi Furnished
                                </option>
                                <option value="unfurnished"
                                    {{ request()->furnish_type == 'unfurnished' ? 'selected' : '' }}>Unfurnished
                                </option>
                            </select>
                        </div>
                        
                        <div class="col-lg-2">
                            <select class="form-select" name="category_id">
                                <option value="">Property Type</option>
                                <option value="36" {{ request()->category_id == '36' ? 'selected' : '' }}>Flat /
                                    Apartment</option>
                                <option value="34" {{ request()->category_id == '34' ? 'selected' : '' }}>Independent
                                    Floor</option>
                                <option value="35" {{ request()->category_id == '35' ? 'selected' : '' }}>Independent
                                    House / Villa</option>
                                <option value="49" {{ request()->category_id == '49' ? 'selected' : '' }}>Farmhouse
                                </option>
                            </select>
                        </div>
                        <!-- Search Button -->
                        <div class="col-lg-2 d-flex">
                            <input type="hidden" name="type" value="{{ request()->type }}">
                            <button type="submit" class="btn btn-primary btn-sm rounded border-primary px-4">Search
                            </button>
                            <button id="clearBtn"
                                class="btn btn-secondary btn-sm rounded border-secondary px-4 mx-1">Clear
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="col-lg-12 col-md-12">
            <h4 class="ipt-title mt-3">
                Properties for Rent in,
                @if (request()->name)
                    {{ request()->name }},
                @endif
                @php
                    $locationName = $locations->where('id', request()->location_id)->first()->name ?? '';
                @endphp
                {{ $locationName }}
            </h4>
            <p class="text-muted small">
                Showing {{ $properties->firstItem() }} to {{ $properties->lastItem() }} of {{ $properties->total() }}
                results
            </p><br>
        </div>
        <div class="row">
            <div class="col-lg-12 col-md-12 col-md-12 list-layout">
                <div class="row">
                    <div class="col-lg-12 col-md-12">
                        <div class="filter-fl">
                            <h4>@lang('Search Results')</h4>
                        </div>
                        <hr>
                    </div>
                    @includeIf('partials.front.rent-property', ['properties' => $topSlotProperties, 'isSponsored' => true])
                    @includeIf('partials.front.rent-property', ['properties' => $mediumSlotProperties, 'isSponsored' => true])
                    @includeIf('partials.front.rent-property', ['properties' => $properties, 'isSponsored' => false])
                    {{-- @includeIf('partials.front.rent-property') --}}
                </div>
            </div>
        </div>
    </div>
    @includeIf('partials.front.cta')
@endsection
@push('js')
    <script src="{{ asset('assets/front/js/map_infobox.js') }}"></script>
    <script src="{{ asset('assets/front/js/markerclusterer.js') }}"></script>
    <script src="{{ asset('assets/front/js/map.js') }}"></script>
    <script>
        $(document).ready(function() {
            // Slugify function
            function slugify(text) {
                return text.toString().toLowerCase().replace(/\s+/g, '-')
                    .replace(/[^\w\-]+/g, '')
                    .replace(/\-\-+/g, '-')
                    .replace(/^-+/, '')
                    .replace(/-+$/, '');
            }

            // Search icon click triggers form submit
            $(".input-group-text").on("click", function() {
                $("#search-form").trigger("submit");
            });

            // Pretty URL submit logic
            $("#search-form").on("submit", function(e) {
                e.preventDefault();
                var cityText = $('#location1 option:selected').text() || '';
                var cityId = $('#location1').val() || '';
                var citySlug = cityText ? slugify(cityText) : 'CITY_PLACEHOLDER';
                var keyword = $('#locality-search').val().trim();
                var localitySlug = keyword ? slugify(keyword) : citySlug;
                var baseUrl = "{{ url('/in') }}";
                var actionUrl = baseUrl + '/rent/property-for-rent-in-' + localitySlug + '-in-' + citySlug;

                // Create a dynamic form for GET
                var $form = $('<form>', {
                    method: 'GET',
                    action: actionUrl
                });
                // Add fields you want to pass to controller
                $form.append($('<input>', {
                    type: 'hidden',
                    name: 'location_id',
                    value: cityId
                }));
                $form.append($('<input>', {
                    type: 'hidden',
                    name: 'name',
                    value: keyword
                }));
                // Add all selected category_id[] checkboxes
                $("#search-form input[name='category_id[]']:checked").each(function() {
                    $form.append($('<input>', {
                        type: 'hidden',
                        name: 'category_id[]',
                        value: $(this).val()
                    }));
                });
                // Add all other fields from the original form (except category_id[] and _token)
                $("#search-form input, #search-form select").not('[name="_token"], [name="category_id[]"]')
                    .each(function() {
                        var $el = $(this);
                        var name = $el.attr('name');
                        var value = $el.val();
                        if (name && value && !$form.find('[name="' + name + '"]')[0]) {
                            $form.append($('<input>', {
                                type: 'hidden',
                                name: name,
                                value: value
                            }));
                        }
                    });
                $form.appendTo('body').submit();
            });

            // Price range dropdown open/close
            $('#priceToggleBtn').on('click', function(e) {
                e.stopPropagation();
                var priceRangeContainer = $('#priceRangeContainer');
                priceRangeContainer.css('display', 'block');
            });
            $(document).on('click', function(e) {
                var priceRangeContainer = $('#priceRangeContainer');
                var priceButton = $('#priceToggleBtn');
                if (!$(e.target).closest('#priceRangeContainer, #priceToggleBtn').length) {
                    priceRangeContainer.css('display', 'none');
                }
            });

            // Range slider update logic
            function formatINR(number) {
    var formatted = new Intl.NumberFormat('en-IN').format(number);
    // Add "+" suffix if it's the max value (1000000)
    if (number == 1000000) {
        return formatted + '+';
    }
    return formatted;
}

// Update the slider update logic
function updateSlider() {
    var minSlider = $('#minRange');
    var maxSlider = $('#maxRange');
    var fillTrack = $('.fill-track');
    var min = parseInt(minSlider.val());
    var max = parseInt(maxSlider.val());
    
    if (min > max) {
        var temp = min;
        min = max;
        max = temp;
        minSlider.val(min);
        maxSlider.val(max);
    }
    
    var range = parseInt(minSlider.attr('max')) - parseInt(minSlider.attr('min'));
    var minPercent = ((min - parseInt(minSlider.attr('min'))) / range) * 100;
    var maxPercent = ((max - parseInt(minSlider.attr('min'))) / range) * 100;
    
    fillTrack.css('left', minPercent + '%');
    fillTrack.css('width', (maxPercent - minPercent) + '%');
    
    // Update visible price labels with "+" for max value
    $('#selectedMinPrice').text(formatINR(min));
    $('#selectedMaxPrice').text(formatINR(max));
    
    // Update button text with "+" for max value
    $('#minPriceValue').text(formatINR(min));
    $('#maxPriceValue').text(formatINR(max));
}

            $('#minRange, #maxRange').on('input', updateSlider);
            updateSlider();

            // Restore filter values from request (after submit)
            function setFilterValuesFromRequest() {
                // City
                var cityId = '{{ request()->location_id ?? '' }}';
                if (cityId) $('#location1').val(cityId);
                // Locality
                var locality = '{{ request()->name ?? '' }}';
                if (locality) $('#locality-search').val(locality);
                // BHK
                var bhk = '{{ request()->no_of_bhk ?? '' }}';
                if (bhk) $('select[name="no_of_bhk"]').val(bhk);
                // Construction Status
                var cs = '{{ request()->furnish_type ?? '' }}';
                if (cs) $('select[name="furnish_type"]').val(cs);
                // Property Type (category_id)
                var cat = '{{ request()->category_id ?? '' }}';
                $('select[name="category_id"]').val(cat);
                // Price Range
                var minPrice = '{{ request()->minPrice ?? '' }}';
                var maxPrice = '{{ request()->maxPrice ?? '' }}';
                if (minPrice) $('#minRange').val(minPrice);
                if (maxPrice) $('#maxRange').val(maxPrice);
                // Update slider visuals
                if (minPrice || maxPrice) updateSlider();
            }
            setFilterValuesFromRequest();

            // Clear button logic
            $('#clearBtn').on('click', function(e) {
                e.preventDefault();
                // Reset all select fields except location
                $('#search-form select').not('#location1').each(function() {
                    $(this).val('');
                });
                // Reset all text inputs
                $('#search-form input[type="text"]').val('');
                // Reset all hidden fields except CSRF
                $('#search-form input[type="hidden"]').not('[name="_token"]').val('');
                // Reset all checkboxes and radios
                $('#search-form input[type="checkbox"], #search-form input[type="radio"]').prop('checked', false);
                // Reset price range
                $('#minRange').val(0);
                $('#maxRange').val(1000000);
                updateSlider();
                // Reset suggestions if any
                $('#suggestions').empty();
            });

        });
         $(document).on('click', '#wishList', function() {
        let $this = $(this);
        let propertyId = $this.data('property');
        let userId = $this.data('user');

        if (!userId) {
            window.location.href = mainurl + '/login-register';
            return;
        }
        console.log("Wishlist Clicked!");

        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            method: "POST",
            url: mainurl + '/property/wishlist',
            data: {
                property_id: propertyId,
                user_id: userId
            },
            success: function(data) {
                if (data.success) {
                    $this.removeClass().addClass('like-bitt add-to-favorite');
                    toastr.success(data.success);
                } else {
                    $this.removeClass().addClass('add-to-favorite');
                    toastr.error(data.error);
                }
                setTimeout(() => {
                    location.reload();
                }, 1000);
            }
        });
    });
    </script>
       <script>
        document.addEventListener("DOMContentLoaded", function() {
            const form = document.getElementById("search-form");

            // On submit, capture and save to localStorage
            form.addEventListener("submit", function() {
                const formData = new FormData(form);
                let searchData = {};

                // Convert FormData to object
                formData.forEach((value, key) => {
                    if (value !== "") {
                        searchData[key] = value;
                    }
                });

                // Add min/max price from sliders (if you're using JS-controlled sliders)
                const minRange = document.getElementById("minRange")?.value;
                const maxRange = document.getElementById("maxRange")?.value;

                if (minRange && maxRange) {
                    searchData.minPrice = minRange;
                    searchData.maxPrice = maxRange;
                }

                // Load recent searches from localStorage
                let recentSearches = JSON.parse(localStorage.getItem("recentSearches")) || [];

                // Avoid duplicates
                let exists = recentSearches.some(search => JSON.stringify(search) === JSON.stringify(
                    searchData));
                if (!exists) {
                    recentSearches.unshift(searchData);
                    if (recentSearches.length > 25) recentSearches.pop(); // Limit to 25
                    localStorage.setItem("recentSearches", JSON.stringify(recentSearches));
                    console.log("✅ Search saved to localStorage:", searchData);
                } else {
                    console.log("ℹ️ Search already exists in localStorage");
                }
            });
        });
    </script>
@endpush
