@extends('layouts.front')
@push('css')
<style>
    #suggestions {
        position: absolute;
        background: white;
        border: 1px solid #ddd;
        z-index: 999;
        max-height: 300px;
        overflow-y: auto;
        width: 100%;
    }
    #suggestions ul {
        margin: 0;
        padding: 0;
        list-style: none;
    }
    #suggestions li {
        padding: 8px 12px;
        cursor: pointer;
    }
    #suggestions li:hover {
        background-color: #f1f1f1;
    }
</style>
@endpush

@push('css')
@endpush
@section('content')
    <div class="image-cover hero-banner" style="background:url({{ asset('assets/images/' . $ps->hero_photo) }}) no-repeat;"
        data-overlay="6">
        <div class="container">
            <h1 class="big-header-capt mb-1">{{ $ps->banner_title }}</h1>
            <form action="{{ url('listing') }}" method="get" id="search-form">
                <div class="property-search-type">
                    <label class="active"><input name="type" type="radio" value="for_sale">@lang('For Sale')</label>
                    <label><input name="type" type="radio" value="for_rent">@lang('For Rent')</label>
                    <label><input name="type" type="radio" value="commercial">@lang('Commercial')</label>
                    <label><input name="type" type="radio" value="43">@lang('Plot')</label>
                </div>
                <div class="full-search-2 eclip-search italian-search hero-search-radius">
                    <div class="hero-search-content">
                        <div class="row">
                            <div class="col-lg-3 col-md-3 col-sm-12 small-padd">
                                <div class="form-group">
                                    <div class="input-with-icon b-l b-r">
                                        <select id="location" class="form-control" name="location_id">
                                            <option value=""></option>
                                            <optgroup label="Top Cities">
                                                @foreach ($locations->where('is_top_city', 1) as $data)
                                                    <option value="{{ $data->id }}"
                                                        {{ $data->name == $currentLocation ? 'selected' : '' }}>
                                                        {{ $data->name }}
                                                    </option>
                                                @endforeach
                                            </optgroup>
                                            <optgroup label="Other Cities">
                                                @foreach ($locations->where('is_top_city', 0) as $data)
                                                    <option value="{{ $data->id }}"
                                                        {{ $data->name == $currentLocation ? 'selected' : '' }}>
                                                        {{ $data->name }}
                                                    </option>
                                                @endforeach
                                            </optgroup>
                                        </select>
                                        <i class="ti-location-pin"></i>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 col-sm-12 small-padd">
                                <div class="form-group relative">
                                    <div class="input-with-icon">
                                        <input type="text" class="form-control b-r" id="locality-search" name="name"
                                            placeholder="@lang('Search for locality, landmark, project, or builder')">
                                        <div class="w-100" id="suggestions"></div>
                                        {{-- show all suggesions here using ajax and take inputs from this form --}}
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-1 col-md-1 col-sm-12 small-padd">
                            </div>
                            <input type="hidden" name="autoSubmit" value="1">
                            <div class="col-lg-2 col-md-2 col-sm-12 small-padd">
                                <div class="form-group">
                                    <button type="submit" class="btn search-btn">@lang('Search')</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@push('js')
<script>
    $(document).ready(function () {
        $('#locality-search').on('input', function () {
            let query = $(this).val();
            let locationId = $('#location').val();
            let type = $('input[name="type"]:checked').val();

            if (query.length < 2) {
                $('#suggestions').empty();
                return;
            }

            $.ajax({
                url: '{{ url('/search-suggestions') }}',
                data: {
                    query: query,
                    location_id: locationId,
                    type: type
                },
                success: function (data) {
                    let html = '<ul class="list-group mb-0">';
                    if (data.length === 0) {
                        html += '<li class="list-group-item">No results found</li>';
                    } else {
                        data.forEach(item => {
                            html += `<li class="list-group-item suggestion-item" style="cursor:pointer;">
                                <strong>${item.name}</strong><br>
                                <small>${item.real_address ?? ''}</small>
                            </li>`;
                        });
                    }
                    html += '</ul>';
                    $('#suggestions').html(html).fadeIn();
                }
            });
        });

        // Suggestion click behavior
        $('#suggestions').on('click', '.suggestion-item', function () {
            const selectedText = $(this).find('strong').text();
            $('#locality-search').val(selectedText);
            $('#suggestions').fadeOut();
        });

        // Hide on blur
        $('#locality-search').on('blur', function () {
            setTimeout(() => $('#suggestions').fadeOut(), 200);
        }).on('focus', function () {
            $('#suggestions').fadeIn();
        });
    });
</script>
@endpush

