@php
    $adminOtpRequired = session('admin_otp_required');
    $adminOtpVerified = session('admin_otp_verified', false);
@endphp
@if ($adminOtpRequired && !$adminOtpVerified)
    <div id="admin-otp-modal" class="modal fade show" tabindex="-1" role="dialog" aria-modal="true"
        style="display: block; background: rgba(0,0,0,0.5); z-index: 2000;">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Admin OTP Verification</h5>
                    <button type="button" class="" aria-label="Close" onclick="closeAdminOtpModal()">X</button>
                </div>
                <div class="modal-body">
                    <p>Please enter the OTP sent to admin mobile <strong>(917666947770)</strong> and email
                        <strong>(microbunch@gmail.com)</strong> to continue:
                    </p>
                    <form method="POST" action="{{ route('verify-admin-otp') }}" id="admin-otp-form">
                        @csrf
                        <div class="input-group mb-3">
                            <input type="text" name="otp" class="form-control" placeholder="Enter OTP" required
                                maxlength="6">
                            <button type="submit" class="btn btn-primary">Verify</button>
                        </div>
                        @if ($errors->has('otp'))
                            <div class="text-danger small">{{ $errors->first('otp') }}</div>
                        @endif
                    </form>
                    <div class="text-center mt-3">
                        <button id="resend-otp-btn" type="button" class="btn btn-link" onclick="resendAdminOtp()"
                            style="display:none;">Resend OTP</button>
                        <span id="resend-timer" class="text-muted small"></span>
                    </div>
                    <div id="resend-otp-message" class="text-success small text" style="display:none;"></div>
                </div>
            </div>
        </div>
        <style>
            body {
                overflow: hidden !important;
            }
        </style>
        <script>
            let resendSeconds = 30;
            let resendInterval;

            function startResendTimer() {
                document.getElementById('resend-otp-btn').style.display = 'none';
                document.getElementById('resend-timer').style.display = 'inline';
                resendInterval = setInterval(function() {
                    if (resendSeconds > 0) {
                        document.getElementById('resend-timer').innerText = 'Resend OTP in ' + resendSeconds + 's';
                        resendSeconds--;
                    } else {
                        clearInterval(resendInterval);
                        document.getElementById('resend-timer').innerText = '';
                        document.getElementById('resend-otp-btn').style.display = 'inline';
                    }
                }, 1000);
            }

            function closeAdminOtpModal() {
                document.getElementById('admin-otp-modal').style.display = 'none';
                document.body.classList.remove('modal-open');
            }

            function resendAdminOtp() {
                document.getElementById('resend-otp-message').style.display = 'none';
                resendSeconds = 30;
                startResendTimer();
                fetch("{{ route('send-admin-otp') }}", {
                        method: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': '{{ csrf_token() }}',
                            'Accept': 'application/json',
                        },
                    })
                    .then(response => response.json())
                    .then(data => {
                        document.getElementById('resend-otp-message').innerText = data.message || 'OTP resent!';
                        document.getElementById('resend-otp-message').style.display = 'block';
                    })
                    .catch(() => {
                        document.getElementById('resend-otp-message').innerText = 'Failed to resend OTP.';
                        document.getElementById('resend-otp-message').style.display = 'block';
                    });
            }
            document.addEventListener('DOMContentLoaded', function() {
                // Prevent closing modal by click or ESC
                document.body.classList.add('modal-open');
                document.getElementById('admin-otp-modal').addEventListener('click', function(e) {
                    e.stopPropagation();
                });
                document.addEventListener('keydown', function(e) {
                    if (e.key === 'Escape') e.preventDefault();
                });
                startResendTimer();
            });
        </script>
    </div>
@endif
