<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="{{ $gs->title }}">
    <meta name="author" content="{{ url('/') }}">
    <link href="{{ asset('assets/images/' . $gs->favicon) }}" rel="icon">
    <title>{{ $gs->title }}</title>
    <link href="{{ asset('assets/admin/fontawesome-free/css/all.min.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/admin/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/admin/css/toastr.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/admin/css/select2.min.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/admin/css/tagify.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/admin/css/bootstrap-colorpicker.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/admin/css/bootstrap-iconpicker.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('assets/admin/css/summernote.css') }}">
    <link href="{{ asset('assets/admin/css/toastr.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/admin/css/plugin.css') }}" rel="stylesheet" />
    <link href="{{ asset('assets/admin/css/ruang-admin.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/admin/css/custom.css') }}" rel="stylesheet">
    <style>
        /* Remove number input spinners globally */
        input[type="number"]::-webkit-outer-spin-button,
        input[type="number"]::-webkit-inner-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }

        input[type="number"] {
            -moz-appearance: textfield;
        }
    </style>
    @yield('styles')
</head>

<body id="page-top">
    @if ($gs->is_admin_loader == 1)
        <div class="Loader"
            style="background: url({{ asset('assets/images/' . $gs->admin_loader) }}) no-repeat scroll center center #FFF;">
        </div>
    @endif
    <div id="wrapper">
        <!-- Sidebar -->
        <ul class="navbar-nav sidebar sidebar-light accordion" id="accordionSidebar">
            <a class="sidebar-brand d-flex align-items-center justify-content-center"
                href="{{ route('agent.dashboard') }}">
                <div class="sidebar-brand-icon">
                    <img src="{{ asset('assets/images/' . $gs->logo) }}">
                </div>
            </a>
            <li class="nav-item">
                <a class="nav-link" href="{{ route('agent.dashboard') }}">
                    <i class="fas fa-fw fa-tachometer-alt"></i>
                    <span>{{ __('Dashboard') }}</span></a>
            </li>
            <li class="nav-item">
                <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#manage_properties"
                    aria-expanded="true" aria-controls="collapseTable">
                    <i class="fa fa-home"></i>
                    <span>{{ __('Manage Properties') }}</span>
                </a>
                <div id="manage_properties" class="collapse" aria-labelledby="headingTable"
                    data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <a class="collapse-item"
                            href="{{ route('agent.properties.index') }}">{{ __('All Properties') }}</a>
                        <a class="collapse-item"
                            href="{{ route('agent.properties.step_1') }}">{{ __('Post Property') }}</a>
                        <a class="collapse-item"
                            href="{{ route('agent.properties.pending') }}">{{ __('Pending Properties') }}</a>
                        <a class="collapse-item"
                            href="{{ route('agent.properties.approved') }}">{{ __('Approved Properties') }}</a>
                    </div>
                </div>
            </li>
            <li class="nav-item">
                <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#lead_section"
                    aria-expanded="false" aria-controls="lead_section">
                    <i class="fas fa-box"></i>
                    <span>Manage Leads</span>
                </a>
                <div id="lead_section" class="collapse" aria-labelledby="headingTable"
                    data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <a class="collapse-item" href="{{ route('agent.properties.enquiries.index') }}">Leads</a>
                        <a class="collapse-item" href="{{ route('agent.view.contacts') }}">View Contacts</a>
                    </div>
                </div>
            </li>
            <li class="nav-item">
                <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#package_section"
                    aria-expanded="false" aria-controls="package_section">
                    <i class="fas fa-box"></i>
                    <span>Packages</span>
                </a>
                <div id="package_section" class="collapse" aria-labelledby="headingTable"
                    data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <a class="collapse-item" href="{{ route('agent.packages.all') }}">All Packages</a>
                        <a class="collapse-item" href="{{ route('agent.packages.active') }}">Active Packages</a>
                        <a class="collapse-item" href="{{ route('agent.expired.packages') }}">
                            Expired Packages</a>
                        <a class="collapse-item" href="{{ route('agent.active.listings') }}">Active
                            Listings</a>
                        <a class="collapse-item" href="{{ route('agent.inactive.listings') }}">Inactive
                            Listings</a>
                    </div>
                </div>
            </li>

            <li class="nav-item">
                <a class="nav-link" href="{{ route('agent.profile') }}">
                    <i class="fas fa-user-circle"></i>
                    <span>{{ __('Profile') }}</span>
                </a>
            </li>

            <li class="nav-item">
                <a class="nav-link" href="{{ route('user.logout') }}">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>{{ __('Logout') }}</span>
                </a>
            </li>



        </ul>
        <!-- Sidebar -->
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <!-- TopBar -->
                <nav class="navbar navbar-expand navbar-light bg-navbar topbar mb-4 static-top">
                    <button id="sidebarToggleTop" class="btn btn-link rounded-circle mr-3">
                        <i class="fa fa-bars"></i>
                    </button>
                    <ul class="navbar-nav ml-auto">
                        <li class="nav-item dropdown no-arrow mx-1">
                            <a class="nav-link pr-0" target="_blank" href="{{ url('/') }}">
                                <i class="fas fa-globe fa-fw"></i>
                            </a>
                        </li>
                        <div class="topbar-divider d-none d-sm-block"></div>
                        <li class="nav-item dropdown no-arrow">
                            <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button"
                                data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <img class="img-profile rounded-circle"
                                    src="{{ auth()->user()->photo ? asset('assets/images/' . auth()->user()->photo) : asset('assets/images/noimage.png') }}"
                                    style="max-width: 60px">
                                <span
                                    class="ml-2 d-none d-lg-inline text-white small">{{ auth()->user()->name }}</span>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right shadow animated--grow-in"
                                aria-labelledby="userDropdown">

                                <a class="dropdown-item" href="{{ route('agent.profile') }}">
                                    <i class="fas fa-user fa-sm fa-fw mr-2 text-gray-400"></i>
                                    @lang('Profile')
                                </a>
                                <a class="dropdown-item" href="{{ route('agent.password') }}">
                                    <i class="fas fa-cogs fa-sm fa-fw mr-2 text-gray-400"></i>
                                    @lang('Change Password')
                                </a>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item" href="{{ route('user.logout') }}">
                                    <i class="fas fa-sign-out-alt fa-sm fa-fw mr-2 text-gray-400"></i>
                                    @lang('Logout')
                                </a>
                            </div>
                        </li>
                    </ul>
                </nav>
                <!-- Topbar -->
                <!-- Container Fluid-->
                <div class="container-fluid" id="container-wrapper">
                    @yield('content')
                </div>
                <!---Container Fluid-->
            </div>
        </div>
    </div>
    <script type="text/javascript">
        'use strict';
        var form_error = "{{ __('Please fill all the required fields') }}";
        var mainurl = "{{ url('/') }}";
    </script>
    <script src="{{ asset('assets/admin/jquery/jquery.min.js') }}"></script>
    <script src="{{ asset('assets/admin/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
    {{-- <script src="{{ asset('assets/admin/jquery-easing/jquery.easing.min.js') }}"></script> --}}
    <script src="{{ asset('assets/admin/js/plugin.js') }}"></script>
    <script src="{{ asset('assets/admin/js/chart.min.js') }}"></script>
    <script src="{{ asset('assets/admin/js/toastr.js') }}"></script>
    <script src="{{ asset('assets/admin/js/bootstrap-colorpicker.js') }}"></script>
    <script src="{{ asset('assets/admin/js/bootstrap-iconpicker.bundle.min.js') }}"></script>
    {{-- <script src="{{ asset('assets/admin/js/colorpicker.js') }}"></script> --}}
    <script src="{{ asset('assets/admin/js/select2.min.js') }}"></script>
    <script src="{{ asset('assets/admin/js/tagify.js') }}"></script>
    <script src="{{ asset('assets/admin/js/summernote.js') }}"></script>
    <script src="{{ asset('assets/admin/js/sortable.js') }}"></script>
    <script src="{{ asset('assets/admin/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('assets/admin/js/bootstrap-datepicker.min.js') }}"></script>
    <script src="{{ asset('assets/front/js/toastr.min.js') }}"></script>
    <script src="{{ asset('assets/admin/js/ruang-admin.js') }}"></script>
    <script src="{{ asset('assets/admin/js/bulk.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        'use strict';
        @if (Session::has('message'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.success("{{ session('message') }}");
        @endif

        @if (Session::has('error'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.error("{{ session('error') }}");
        @endif

        @if (Session::has('info'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.info("{{ session('info') }}");
        @endif

        @if (Session::has('warning'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.warning("{{ session('warning') }}");
        @endif

        // Prevent negative values in all number inputs
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('input[type="number"]').forEach(input => {
                // Set minimum value to 0 if not already set
                if (!input.hasAttribute('min')) {
                    input.setAttribute('min', '0');
                }

                // Prevent negative values on keypress
                input.addEventListener('keydown', function(e) {
                    if (e.key === '-' || e.key === 'e' || e.key === 'E') {
                        e.preventDefault();
                    }
                });

                // Ensure value stays positive on blur
                input.addEventListener('blur', function() {
                    if (this.value < 0) {
                        this.value = 0;
                    }
                });
            });
            const dateInputs = document.querySelectorAll('input[type="date"]');

            dateInputs.forEach(input => {
                input.addEventListener('click', function() {
                    if (this.showPicker) {
                        this.showPicker(); // Trigger native date picker
                    }
                });
            });
        });
    </script>

    @yield('scripts')


</body>

</html>
