<!DOCTYPE html>
<html lang="zxx">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <meta name="description"
        content="Veloxinfra.com is a Real Estate company. You can Buy Property, Sell Property and Rent Property.Best Online Market Place Real Estate Company For Property owner, Agent and Builder.">

    <meta name="keywords"
        content="Veloxinfra, Velox infra, Buy Property, Sell Property, Rent Property, Post Property, List Property, Online Real Estate Company, Online Property. ">

    <title>{{ $gs->title }}</title>

    <link href="{{ asset('assets/front/css/styles.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/front/css/colors.css') }}" rel="stylesheet">

    <link rel="stylesheet" href="{{ asset('assets/front/css/styles.php?color=' . str_replace('#', '', $gs->colors)) }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

    @if ($default_font->font_value)
    <link href="https://fonts.googleapis.com/css?family={{ $default_font->font_value }}&display=swap"
        rel="stylesheet">
    @else
    <link href="https://fonts.googleapis.com/css?family=Open+Sans&display=swap" rel="stylesheet">
    @endif

    @if ($default_font->font_family)
    <link rel="stylesheet" id="colorr"
        href="{{ asset('assets/front/css/font.php?font_familly=' . $default_font->font_family) }}">
    @else
    <link rel="stylesheet" id="colorr"
        href="{{ asset('assets/front/css/font.php?font_familly=' . 'Open Sans') }}">
    @endif

    <link rel="stylesheet" href="{{ asset('assets/front/css/bootstrap-datepicker.min.css') }}">

    <link rel="stylesheet" href="{{ asset('assets/front/css/toastr.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/front/css/custom1.css') }}" />
    <link rel="shortcut icon" href="{{ asset('assets/images/' . $gs->favicon) }}">
    @stack('css')

    <!--@if (!empty($seo->google_analytics))
-->
    <!--<script>
        -- >
        <
        !--window.dataLayer = window.dataLayer || [];
        -- >
        <
        !-- function gtag() {
            -- >
            <
            !--dataLayer.push(arguments);
            -- >
            <
            !--
        }-- >
        <
        !--gtag('js', new Date());
        -- >
        <
        !--gtag('config', '{{ $seo->google_analytics }}');
        -- >
        <
        !--
    </script>-->
    <!--
@endif-->

    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-T1GZV0G4F3"></script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }
        gtag('js', new Date());
        gtag('config', 'G-T1GZV0G4F3');
    </script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        .input-with-icon input,
        .input-with-icon select {
            padding-left: 10px;
            padding-right: 10px;
            padding-top: 5px;
            padding-bottom: 5px;
        }

        .form-group {
            margin-bottom: 10px;
        }

        .search-header-banner .form-control,
        .search-header-banner select,
        .search-header-banner select option {
            font-size: 14px;
        }

        .custom-btn {
            height: 35px;
            display: flex;
            align-items: center;
            justify-content: center;
            white-space: nowrap;
            border-radius: 10px;
            border: #3936f8
        }

        .property-img img {
            width: 420px;
            height: 280px;
            object-fit: cover;
        }

        @media (max-width: 768px) {
            .property-img img {
                width: 100%;
                height: 280px;

            }
        }

        .share-container {
            position: relative;
        }

        .share-icon {
            cursor: pointer;
            width: 40px;
        }

        .share-options {
            display: none;
            position: absolute;
            bottom: 0;
            right: 0%;
            transform: translateX(-50%);
            background: #d8d5d5;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            border-radius: 5px;
            border: #7a7171 padding: 10px;
            z-index: 1000;
        }

        .share-options a {
            display: flex;
            align-items: center;
            padding: 10px;
            color: #007bff;
            text-decoration: none;
        }

        .share-options a:hover {
            background-color: #f0f0f0;
        }

        .share-options img {
            margin-right: 10px;
            width: 20px;
            height: 20px;
        }

        body {
            font-size: 14px;
        }


        .property-features {
            color: black !important;
        }

        .property-search {
            margin-bottom: 10px;
            display: flex;
            align-items: center;
            gap: 4px;
            /* buttons ke beech space */
            padding: 2px;
            overflow-x: auto;
            /* mobile me horizontal scroll */
            -webkit-overflow-scrolling: touch;
            white-space: nowrap;
            /* force single line */
            flex-wrap: nowrap;
            /* wrap bilkul nahi hoga */
            scrollbar-width: thin;
            /* firefox */
        }

        /* (optional) webkit scrollbars ko slim bana do */
        .property-search::-webkit-scrollbar {
            height: 4px;
        }

        .property-search::-webkit-scrollbar-thumb {
            border-radius: 10;
        }

        /* Links as pills */
        .property-search a {
            flex: 0 0 auto;
            /* shrink mat hona */
            text-decoration: none;
        }

        /* Label styling */
        .property-search label {
            display: block;
            padding: 10px 16px;
            border-radius: 5px;
            border: 1px solid #e5e7eb;
            font-size: 14px;
            line-height: 1;
            text-transform: uppercase;
            color: #111827;
            /* near-black */
            background: #ffffff;
            transition: background .2s ease, color .2s ease, border-color .2s ease;
            white-space: nowrap;
            /* safety */
            cursor: pointer;
        }

        /* Active tab (aapke HTML me label par class="active" hai) */
        .property-search label.active {
            background: #f02c2d;
            color: #ffffff;
            border-color: #f02c2d;
        }

        /* Hover/focus states */
        .property-search a:hover label,
        .property-search a:focus-visible label {
            border-color: #f02c2d;
        }

        /* Desktop par center align */

        @media (max-width: 480px) {
            .property-search {
                justify-content: center;
            }

            .property-search label {
                padding: 4px 10px;
                /* kam padding */
                gap: 1px;
            }
        }

        @media (max-width: 767.98px) {
            #search-form * {
                font-size: 11px !important;
            }
        }

        @media (min-width: 768px) {
            .property-search {
                justify-content: center;
            }

            .view-contact {
                font-size: 16px;
            }
        }
        .view-contact {
            font-size: 25px !important;
        }
    </style>
</head>

<body class="red-skin">

    <!-- ============================================================== -->
    <!-- Preloader - style you can find in spinners.css -->
    <!-- ============================================================== -->

    <!--<div id="preloader"><div class="preloader"><span></span><span></span></div></div>-->

    @if ($gs->is_admin_loader == 1)
    <div class="Loader"
        style="background: url({{ asset('assets/images/' . $gs->admin_loader) }}) no-repeat scroll center center #FFF;">
    </div>
    @endif
    <!-- ============================================================== -->
    <!-- Main wrapper - style you can find in pages.scss -->
    <!-- ============================================================== -->
    <div id="main-wrapper">

        <!-- ============================================================== -->
        <!-- Top header  -->
        <!-- ============================================================== -->
        <!-- Start Navigation -->
        <div class="header header-light head-shadow">
            @includeIf('partials.front.nav')
        </div>
        <!-- End Navigation -->
        <div class="clearfix"></div>
        <!-- ============================================================== -->
        <!-- Top header  -->
        <!-- ============================================================== -->

        @yield('content')

        <!-- ============================ Footer Start ================================== -->
        @include('partials.front.footer')
        <!-- ============================ Footer End ================================== -->

        <a id="back2Top" class="top-scroll" title="Back to top" href="#"><i class="ti-arrow-up"></i></a>
    </div>
    <!-- ============================================================== -->
    <!-- End Wrapper -->
    <!-- ============================================================== -->


    {{-- @if ($gs->is_cookie)
    @include('cookie-consent::index')
    @endif --}}


    <!-- ============================================================== -->
    <!-- All Jquery -->
    <!-- ============================================================== -->
    <script src="{{ asset('assets/front/js/jquery-3.6.0.min.js') }}"></script>
    <script src="{{ asset('assets/front/js/popper.min.js') }}"></script>
    <script src="{{ asset('assets/front/js/bootstrap.min.js') }}"></script>
    <script src="{{ asset('assets/front/js/bootstrap-datepicker.min.js') }}"></script>
    <script src="{{ asset('assets/front/js/moment.min.js') }}"></script>
    <script src="{{ asset('assets/front/js/rangeslider.js') }}"></script>
    <script src="{{ asset('assets/front/js/select2.min.js') }}"></script>
    <script src="{{ asset('assets/front/js/jquery.magnific-popup.min.js') }}"></script>
    <script src="{{ asset('assets/front/js/slick.js') }}"></script>
    <script src="{{ asset('assets/front/js/slider-bg.js') }}"></script>
    <script src="{{ asset('assets/front/js/lightbox.js') }}"></script>
    <script src="{{ asset('assets/front/js/imagesloaded.js') }}"></script>
    <script src="{{ asset('assets/front/js/toastr.min.js') }}"></script>
    <script src="{{ asset('assets/front/js/notify.js') }}"></script>
    <script src="{{ asset('assets/front/js/custom.js') }}"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const phoneInput = document.getElementById('phone'); // Get phone input element
            if (phoneInput) {
                try {
                    const iti = intlTelInput(phoneInput, {
                        initialCountry: "in",
                        separateDialCode: true,
                        preferredCountries: ["in", "us", "gb"],
                        utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/utils.js",
                    });
                } catch (error) {
                    console.error('Error initializing intlTelInput:', error);
                }
            }
        });
    </script>
    <script>
        'use strict';
        let mainurl = '{{ url(' / ') }}';
        let tawkto = '{{ $gs->is_talkto }}';
    </script>


    <script type="text/javascript">
        if (tawkto == 1) {
            var Tawk_API = Tawk_API || {},
                Tawk_LoadStart = new Date();
            (function() {
                var s1 = document.createElement("script"),
                    s0 = document.getElementsByTagName("script")[0];
                s1.async = true;
                s1.src = 'https://embed.tawk.to/{{ $gs->talkto }}';
                s1.charset = 'UTF-8';
                s1.setAttribute('crossorigin', '*');
                s0.parentNode.insertBefore(s1, s0);
            })();
        }
    </script>


    <script>
        'use strict';

        @if(Session::has('message'))
        toastr.options = {
            "closeButton": true,
            "progressBar": true
        }
        toastr.success("{{ session('message') }}");
        @endif

        @if(Session::has('error'))
        toastr.options = {
            "closeButton": true,
            "progressBar": true
        }
        toastr.error("{{ session('error') }}");
        @endif

        @if(Session::has('info'))
        toastr.options = {
            "closeButton": true,
            "progressBar": true
        }
        toastr.info("{{ session('info') }}");
        @endif

        @if(Session::has('warning'))
        toastr.options = {
            "closeButton": true,
            "progressBar": true
        }
        toastr.warning("{{ session('warning') }}");
        @endif

        @if($errors-> any())
        @foreach($errors-> all() as $error)
        toastr.options = {
            "closeButton": true,
            "progressBar": true
        }
        toastr.warning("{{ $error }}");
        @endforeach
        @endif
    </script>

    @stack('js')
</body>

</html>