<!DOCTYPE html>
<html lang="zxx">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <title>{{ $gs->title }}</title>
    <link href="{{ asset('assets/front/css/styles.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/front/css/colors.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('assets/front/css/styles.php?color=' . str_replace('#', '', $gs->colors)) }}">
    @if ($default_font->font_value)
        <link href="https://fonts.googleapis.com/css?family={{ $default_font->font_value }}&display=swap"
            rel="stylesheet">
    @else
        <link href="https://fonts.googleapis.com/css?family=Open+Sans&display=swap" rel="stylesheet">
    @endif
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    @if ($default_font->font_family)
        <link rel="stylesheet" id="colorr"
            href="{{ asset('assets/front/css/font.php?font_familly=' . $default_font->font_family) }}">
    @else
        <link rel="stylesheet" id="colorr"
            href="{{ asset('assets/front/css/font.php?font_familly=' . ' Open Sans') }}">
    @endif
    <link rel="stylesheet" href="{{ asset('assets/front/css/bootstrap-datepicker.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/front/css/toastr.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/front/css/custom.css') }}" />
    <link rel="shortcut icon" href="{{ asset('assets/images/' . $gs->favicon) }}">
    @stack('css')
    @if (!empty($seo->google_analytics))
        <script>
            window.dataLayer = window.dataLayer || [];

            function gtag() {
                dataLayer.push(arguments);
            }
            gtag('js', new Date());
            gtag('config', '{{ $seo->google_analytics }}');
        </script>
    @endif
    <style>
        .sidebar-wrapper {
            transition: all 0.3s ease-in-out;
        }

        .content-wrapper {
            transition: all 0.3s ease-in-out;
        }
    </style>
</head>

<body class="red-skin">
    <!-- ============================================================== -->
    <div id="main-wrapper">
        <!-- ============================================================== -->
        <!-- Top header  -->
        <!-- ============================================================== -->
        <!-- Start Navigation -->
        <div class="header header-light head-shadow">
            @includeIf('partials.front.nav')
        </div>
        <!-- End Navigation -->
        <div class="clearfix"></div>
        <!-- ============================================================== -->
        <!-- Top header  -->
        <!-- ============================================================== -->
        @yield('title')
        <!-- ============================ User Dashboard ================================== -->
        <section>
            <div class="container-fluid">
                <div class="row">
                    <!-- Toggle Button (visible always) -->
                    <div class="col-12">
                        <button id="toggleSidebar" class="btn btn-secondary">
                            <i class="fas fa-bars"></i>
                        </button>
                    </div>

                    <!-- Sidebar -->
                    <div class="col-lg-3 col-md-4 sidebar-wrapper" id="sidebarWrapper">
                        <div class="dashboard-navbar">
                            <div class="d-user-avater">
                                <img src="{{ asset('assets/images/' . auth()->user()->photo) }}"
                                    class="img-fluid avater" alt="">
                                <h4>{{ auth()->user()->name }}</h4>
                            </div>
                            <div class="d-navigation">
                                <ul>
                                    @include('partials.user.sidebar')
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Content -->
                    <div class="col-lg-9 col-md-8 content-wrapper" id="contentWrapper">
                        @yield('content')
                    </div>
                </div>


            </div>
        </section>
        <!-- ============================ User Dashboard End ================================== -->
        <!-- ============================ Footer Start ================================== -->
        @include('partials.front.footer')
        <!-- ============================ Footer End ================================== -->
        <a id="back2Top" class="top-scroll" title="Back to top" href="#"><i class="ti-arrow-up"></i></a>
    </div>
    <!-- ============================================================== -->
    <!-- End Wrapper -->
    <!-- ============================================================== -->
    @if ($gs->is_cookie)
        @include('cookie-consent::index')
    @endif
    <!-- ============================================================== -->
    <!-- All Jquery -->
    <!-- ============================================================== -->
    <script src="{{ asset('assets/front/js/jquery-3.6.0.min.js') }}"></script>
    <script src="{{ asset('assets/front/js/popper.min.js') }}"></script>
    <script src="{{ asset('assets/front/js/bootstrap.min.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/js/bootstrap-datepicker.min.js"></script>
    <script src="{{ asset('assets/front/js/moment.min.js') }}"></script>
    <script src="{{ asset('assets/front/js/rangeslider.js') }}"></script>
    <script src="{{ asset('assets/front/js/select2.min.js') }}"></script>
    <script src="{{ asset('assets/front/js/jquery.magnific-popup.min.js') }}"></script>
    <script src="{{ asset('assets/front/js/slick.js') }}"></script>
    <script src="{{ asset('assets/front/js/slider-bg.js') }}"></script>
    <script src="{{ asset('assets/front/js/lightbox.js') }}"></script>
    <script src="{{ asset('assets/front/js/imagesloaded.js') }}"></script>
    <script src="{{ asset('assets/front/js/toastr.min.js') }}"></script>
    <script src="{{ asset('assets/front/js/notify.js') }}"></script>
    <script src="{{ asset('assets/front/js/custom.js') }}"></script>
    <script>
        'use strict';
        let mainurl = '{{ url('/') }}';
        let tawkto = '{{ $gs->is_talkto }}';
    </script>
    <script type="text/javascript">
        if (tawkto == 1) {
            var Tawk_API = Tawk_API || {},
                Tawk_LoadStart = new Date();
            (function() {
                var s1 = document.createElement("script"),
                    s0 = document.getElementsByTagName("script")[0];
                s1.async = true;
                s1.src = 'https://embed.tawk.to/{{ $gs->talkto }}/default';
                s1.charset = 'UTF-8';
                s1.setAttribute('crossorigin', '*');
                s0.parentNode.insertBefore(s1, s0);
            })();
        }
    </script>
    <script>
        'use strict';
        @if (Session::has('message'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.success("{{ session('message') }}");
        @endif
        @if (Session::has('error'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.error("{{ session('error') }}");
        @endif
        @if (Session::has('info'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.info("{{ session('info') }}");
        @endif
        @if (Session::has('warning'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.warning("{{ session('warning') }}");
        @endif
        @if ($errors->any())
            @foreach ($errors->all() as $error)
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true
                }
                toastr.warning("{{ $error }}");
            @endforeach
        @endif
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const toggleButton = document.getElementById('toggleSidebar');
            const sidebar = document.getElementById('sidebarWrapper');
            const content = document.getElementById('contentWrapper');

            toggleButton.addEventListener('click', function() {
                sidebar.classList.toggle('d-none');

                if (sidebar.classList.contains('d-none')) {
                    content.classList.remove('col-md-8', 'col-lg-9');
                    content.classList.add('col-md-12');
                } else {
                    content.classList.remove('col-md-12');
                    content.classList.add('col-md-8', 'col-lg-9');
                }
            });
        });
    </script>


    @stack('js')
</body>
<style>
    .input-with-icon input,
    .input-with-icon select {
        padding-left: 10px;
        padding-right: 10px;
        padding-top: 5px;
        padding-bottom: 5px;
    }

    .form-group {
        margin-bottom: 10px;
    }

    .search-header-banner .form-control,
    .search-header-banner select,
    .search-header-banner select option {
        font-size: 14px;
        /* Sabka text size 12px ho jayega */
    }

    .custom-btn {
        height: 35px;
        display: flex;
        align-items: center;
        justify-content: center;
        white-space: nowrap;
        border-radius: 10px;
        border: #3936f8
    }

    .property-img img {
        width: 420px;
        height: 280px;
        object-fit: cover;
    }

    @media (max-width: 768px) {
        .property-img img {
            width: 100%;
            height: 280px;
        }
    }

    .share-container {
        position: relative;
    }

    .share-icon {
        cursor: pointer;
        width: 40px;
    }

    .share-options {
        display: none;
        position: absolute;
        bottom: 0;
        right: 0%;
        transform: translateX(-50%);
        background: #d8d5d5;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        border-radius: 5px;
        border: #7a7171 padding: 10px;
        z-index: 1000;
    }

    .share-options a {
        display: flex;
        font-size: 12px;
        align-items: center;
        padding: 5px;
        color: #007bff;
        text-decoration: none;
    }

    .share-options a:hover {
        background-color: #f0f0f0;
    }

    .share-options img {
        margin-right: 10px;
        width: 20px;
        height: 20px;
    }

    section {
        padding: 0px 0;
    }

    .page-title {
        width: 100%;
        height: 100px;
        text-align: left;
        display: flex;
        flex-direction: column;
        align-items: center;
        flex-wrap: wrap;
        justify-content: center;
        background: #ffffff;
    }

    .dashboard-stat {
        display: inline-block;
        padding: 0;
        height: 90px;
        background-color: #444;
        color: #fff;
        border-radius: 4px;
        width: 100%;
        position: relative;
        margin-bottom: 20px;
        overflow: hidden;
        transition: 0.3s;
        cursor: default;
    }

    .dashboard-stat-content span {
        font-size: 16px;
        margin-top: 4px;
        line-height: 24px;
        font-weight: 300;
        display: inline-block;
    }
</style>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

</html>
