@pushOnce('css')
    <style>
        .share-options {
            display: none;
            position: absolute;
            bottom: 40px;
            right: 0;
            background: #d8d5d5;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            border-radius: 5px;
            /* border: 1px solid #7a7171; */
            padding: 10px 20px;
            z-index: 999;
            min-width: 160px;
        }

        @media (max-width: 767.98px) {
            .property-img {
                position: static;
                width: 100%;
                height: auto;
                object-fit: contain;
            }
        }      
    </style>
@endPushOnce
@forelse ($properties as $key => $data)
    <div class="col-lg-12 col-md-12">
        <a href="{{ route('commercial.details', $data->slug) }}" target="_blank">
            <div
                class="property-card d-flex flex-wrap flex-md-nowrap shadow-lg rounded-3 overflow-hidden position-relative m-4">
                <!-- Left Side: Property Image -->
                <div class="property-img position-relative ">
                    <img src="{{ asset('assets/images/' . $data->photo) }}" class="img-fluid" alt="Property Image"
                        style="object-fit: cover;">
                    <!-- Wishlist Icon -->
                    <div class="wishlist-icon position-absolute top-0 end-0 p-2">
                        <a href="JavaScript:Void(0);" id="wishList"
                            class="{{ $data->checkFavourite(auth()->id(), $data->id) ? 'like-bitt' : '' }} add-to-favorite"
                            data-property="{{ $data->id }}" data-user="{{ auth()->id() }}" data-bs-toggle="tooltip"
                            data-original-title="Add To Favorites">
                            <i class="lni-heart-filled"></i>
                        </a>
                    </div>
                    <!-- Rating -->
                    @if ($data->reviews->count() > 0)
                        <div class="listing-rating position-absolute bottom-0 start-0 p-2 bg-dark text-white rounded">
                            @php
                                $review = $data->reviews->sum('rate') / $data->reviews->count();
                            @endphp
                            @for ($i = 1; $i <= $review; $i++)
                                <i class="ti-star filled text-warning"></i>
                            @endfor
                            @if (is_float($review))
                                <i class="ti-star text-warning"></i>
                            @endif
                        </div>
                    @endif
                    <!-- Property Type Label -->
                    <span class="property-type position-absolute top-0 start-0 p-1 bg-primary small text-white rounded">
                        {{ $data->looking_for == 'for_rent' ? __('For Rent') : __('For Sell') }}
                        @if (!empty($isSponsored))
                        . Sponsored
                    @endif
                    </span>
                </div>
                <!-- Right Side: Property Details -->
                <div class="property-details px-4 flex-grow-1" style="width: 50%;">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="property-price mt-4" style="color: #3936f8">{{ showAmount($data->price) ?? '' }}
                        </h4>
                        <!-- Share Button -->
                        <svg class="mt-2" xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="24"
                            height="22" viewBox="0 0 30 30" style="fill:#474646;"
                            onclick="toggleShareOptions(event, '{{ $data->id }}')">
                            <path
                                d="M 23 3 C 20.791 3 19 4.791 19 7 C 19 7.2869826 19.034351 7.5660754 19.091797 7.8359375L 10 12.380859 C 9.2667379 11.541629 8.2018825 11 7 11 C 4.791 11 3 12.791 3 15 C 3 17.209 4.791 19 7 19 C 8.2018825 19 9.2667379 18.458371 10 17.619141 L 19.091797 22.164062 C 19.034351 22.433925 19 22.713017 19 23 C 19 25.209 20.791 27 23 27 C 25.209 27 27 25.209 27 23 C 27 20.791 25.209 19 23 19 C 21.798117 19 20.733262 19.541629 20 20.380859 L 10.908203 15.835938 C 10.965649 15.566075 11 15.286983 11 15 C 11 14.713017 10.965649 14.433925 10.908203 14.164062 L 20 9.6191406 C 20.733262 10.458371 21.798117 11 23 11 C 25.209 11 27 9.209 27 7 C 27 4.791 25.209 3 23 3 z">
                            </path>
                        </svg>
                        <!-- Share Options -->
                        <div class="share-options" id="shareOptions-{{ $data->id }}" style="display: none;">
                            <a href="#" onclick="copyLink('{{ route('commercial.details', $data->slug) }}')"><i
                                    class="ti-link"></i>&nbsp;&nbsp; Copy Link &nbsp;</a>
                            <a href="#"
                                onclick="share('whatsapp', '{{ route('commercial.details', $data->slug) }}')"><i
                                    class="fa-brands fa-whatsapp"></i>&nbsp;&nbsp; WhatsApp &nbsp;</a>
                            <a href="#"
                                onclick="share('instagram', '{{ route('commercial.details', $data->slug) }}')"><i
                                    class="ti-instagram"></i>&nbsp;&nbsp; Instagram &nbsp;</a>
                            <a href="#"
                                onclick="share('facebook', '{{ route('commercial.details', $data->slug) }}')"><i
                                    class="ti-facebook"></i>&nbsp;&nbsp; Facebook &nbsp;</a>
                            <a href="#"
                                onclick="share('twitter', '{{ route('commercial.details', $data->slug) }}')"><i
                                    class="fa-brands fa-x"></i>&nbsp;&nbsp; Twitter &nbsp;</a>
                            <a href="#"
                                onclick="share('linkedin', '{{ route('commercial.details', $data->slug) }}')"><i
                                    class="ti-linkedin"></i>&nbsp;&nbsp; Linkedin &nbsp;</a>
                        </div>
                    </div>
                    <div class="d-flex align-items-center justify-content-between mb-2">
                        <div>
                            <h5 class="property-title mt-2">{{ ucwords($data->name) ?? '' }}</h5>
                            <p class="property-location text-dark">
                                <i class="ti-location-pin"></i> {{ ucwords(strtolower($data->locality)) ?? '' }},
                                {{ ucwords($data->location->name) ?? '' }}
                            </p>
                        </div>
                        <div class="ms-auto text-end text-dark">
                            <span>{{ ucwords($data->user->name) ?? '' }}</span><br>
                            <span class="">{{ strtolower($data->user->user_type) == 'builder/developer' ? 'Developer' : ucwords($data->user->user_type) }}</span>
                        </div>
                    </div>
                    <!-- Features -->
                    <div class="property-features row g-2 mt-3">
                        @if (!empty($data->price_per_sqft) && $data->looking_for == 'for_sell')
                            <div class="col-6 col-md-3 col-lg mb-2">
                                <div>
                                    <p class="mb-0 small">Price/{{ $data->area_unit == 'sqft' ? 'Sq.Ft.' : 'Sq.Mtr' }}</p>
                                    <small>₹{{ $data->price_per_sqft }}</small>
                                </div>
                            </div>
                        @endif

                        @if (!empty($data->carpet_area))
                            <div class="col-6 col-md-3 col-lg mb-2">
                                <div>
                                    <p class="mb-0 small">Carpet Area</p>
                                    <small>{{ $data->carpet_area }}
                                        {{ $data->area_unit == 'sqft' ? 'Sq.Ft.' : 'Sq.Mtr' }}</small>
                                </div>
                            </div>
                        @endif

                        @if (!empty($data->property_on_floor) && !empty($data->total_floors))
                            <div class="col-6 col-md-3 col-lg mb-2">
                                <div>
                                    <p class="mb-0 small">Floors</p>
                                    <small>{{ $data->property_on_floor }}/{{ $data->total_floors }}</small>
                                </div>
                            </div>
                        @endif

                        @if (!empty($data->construction_status))
                            <div class="col-6 col-md-3 col-lg mb-2">
                                <div>
                                    <p class="mb-0 small">Possession Status</p>
                                    <small>{{ ucwords(str_replace('-', ' ', $data->construction_status)) }}</small>
                                </div>
                            </div>
                        @endif

                    </div>

                    <!-- CTA Buttons -->
                    <div class="d-flex gap-1 flex-nowrap py-4">
                        <!-- More Info Button -->
                        <a href="{{ route('commercial.details', $data->slug) }}" target="_blank"
                            class="btn btn-primary btn-sm flex-grow-1 custom-btn text-light text-center">
                            @lang('More Info')
                        </a>

                        @if ($data->user)
                        @auth
                        <button type="button"
                            class="btn btn-primary btn-sm w-25 custom-btn"
                            onclick="viewContact('{{ $data->id }}', '{{ $data->user->name }}', '{{ $data->user->phone }}')">
                            View Contact
                        </button>

                        <!-- Modal -->
                        <div class="modal fade" id="contactModal" tabindex="-1" role="dialog"
                            aria-labelledby="contactModalLabel" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="contactModalLabel">Contact Details</h5>
                                        <button type="button" class="close" data-bs-dismiss="modal"
                                            aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body">
                                        <p><strong>Name:</strong> <span id="contactName"></span></p>
                                        <p><strong>Phone:</strong> <span id="contactPhone"></span></p>
                                        <div id="contactAlert"></div>
                                    </div>
                                    {{-- <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary modal-close-btn"
                                            data-bs-dismiss="modal">Close</button>
                                    </div> --}}
                                </div>
                            </div>
                        </div>

                        <script>
                            function viewContact(propertyId, name, phone) {
                                // Show modal first (optimistic UI)
                                document.getElementById('contactName').innerText = name;
                                document.getElementById('contactPhone').innerText = '+91-' + phone;
                                $('#contactModal').modal('show');

                                // Send AJAX request to log the view
                                $.ajax({
                                    url: "{{ route('property.viewContact') }}",
                                    type: "POST",
                                    data: {
                                        _token: "{{ csrf_token() }}",
                                        property_id: propertyId,
                                        contact_type: 'view_contact'
                                    },
                                    success: function(response) {
                                        let alertBox = document.getElementById('contactAlert');
                                        alertBox.innerHTML = `<div class="alert alert-${response.status} mt-2">${response.message}</div>`;
                                    },
                                    error: function(xhr) {
                                        let alertBox = document.getElementById('contactAlert');
                                        alertBox.innerHTML = `<div class="alert alert-danger mt-2">Something went wrong. Please try again.</div>`;
                                    }
                                });
                            }
                        </script>
                        @else
                        <button class="btn btn-primary btn-sm flex-grow-1 custom-btn w-100" onclick="redirectToLogin()">
                            View Contact
                        </button>
                        @endauth
                        @endif

                        @if ($data->user)
                        @auth
                        <!-- Enquiry / Contact Button -->
                        <form action="{{ route('property.viewContact') }}" method="POST" class="d-inline flex-grow-1">
                            @csrf
                            <input type="hidden" name="property_id" value="{{ $data->id }}">
                            <input type="hidden" name="contact_type" value="enquiry">
                            <button type="submit" data-bs-toggle="modal" data-bs-target="#contactForm"
                                class="btn btn-primary btn-sm w-100 custom-btn">
                                Contact {{ strtolower($data->user->user_type) == 'builder/developer' ? 'Developer' : ucwords($data->user->user_type) }}
                            </button>
                        </form>
                        @else
                        <button class="btn btn-primary btn-sm flex-grow-1 custom-btn w-100" onclick="redirectToLogin()">
                            Contact Seller
                        </button>
                        @endauth
                        @endif
                    </div>

                    <!-- Contact Modal -->
                    <div class="modal fade" id="contactForm" tabindex="-1" aria-labelledby="contactFormLabel"
                        aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="contactFormLabel">Contact Seller</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <div id="successMessage" style="text-align:center;">
                                        <img src="{{ asset('assets/images/success-icon-10.png') }}" alt="Success"
                                            width="50">
                                        <p>Seller details are now available in your user login dashboard.</p>
                                    </div>
                                    <form id="contactForm1" action="{{ route('user.property.enquiry') }}"
                                        method="post">
                                        @csrf
                                        <input type="hidden" name="property_id" value="{{ $data->id }}">
                                        <input type="hidden" name="name">
                                        <input type="hidden" name="phone">
                                        <input type="hidden" name="email">
                                        <input type="hidden" name="property_owner_id"
                                            value="{{ $data->property ? $data->user_id : '' }}">
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </a>
    </div>
@empty
     @if (empty($isSponsored))
        <p>No properties found.</p>
    @endif
@endforelse

<div class="row">
    <div class="col-lg-12 col-md-12 col-sm-12">
        @if (method_exists($properties, 'hasPages') && $properties->hasPages())
        {{ $properties->links() }}
        @endif
    </div>
</div>

@pushOnce('js')
<script>
    function showLoginPrompt() {
        alert('You need to log in to view contact details.');
        window.location.href = "{{ route('user.otp') }}";
    }

    function showContactModal(name, phone) {
        document.getElementById('contactName').innerText = name;
        document.getElementById('contactPhone').innerText = '+91-' + phone;
        $('#contactModal').modal('show');
    }

    function closeModal() {
        $('#contactModal').modal('hide');
    }

    function redirectToLogin() {
        window.location.href = "{{ route('user.otp') }}";
    }
    $(document).on('click', '.modal-close-btn', function() {
        closeModal();
    });

    function toggleShareOptions(event, propertyId) {
        event.preventDefault();
        var shareOptions = document.getElementById('shareOptions-' + propertyId);
        shareOptions.style.display = (shareOptions.style.display === 'none' || shareOptions.style.display === '') ?
            'block' : 'none';
        setTimeout(function() {
            shareOptions.style.display = 'none';
        }, 3000);
    }

    function share(platform, url) {
        let text = "Check this out!";
        let shareUrl = "";
        switch (platform) {
            case 'facebook':
                shareUrl = `https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(url)}`;
                break;
            case 'twitter':
                shareUrl =
                    `https://twitter.com/intent/tweet?text=${encodeURIComponent(text)}&url=${encodeURIComponent(url)}`;
                break;
            case 'instagram':
                shareUrl = `https://www.instagram.com/?url=${encodeURIComponent(url)}`;
                break;
            case 'linkedin':
                shareUrl = `https://www.linkedin.com/sharing/share-offsite/?url=${encodeURIComponent(url)}`;
                break;
            case 'whatsapp':
                shareUrl = `https://wa.me/?text=${encodeURIComponent(text)}%20${encodeURIComponent(url)}`;
                break;
            default:
                console.log("Unsupported platform");
                return;
        }
        if (shareUrl) {
            window.open(shareUrl, '_blank', 'noopener,noreferrer');
        }
    }

    function copyLink(url) {
        navigator.clipboard.writeText(url).then(function() {
            alert('Link copied to clipboard: ' + url);
        }, function(err) {
            console.error('Could not copy text: ', err);
        });
    }
    document.addEventListener("DOMContentLoaded", function() {
        var closeModalBtns = document.querySelectorAll('[data-bs-dismiss="modal"]');
        closeModalBtns.forEach(function(btn) {
            btn.addEventListener('click', function() {
                var myModalEl = document.getElementById('contactForm');
                var modalInstance = bootstrap.Modal.getInstance(myModalEl);
                modalInstance.hide();
            });
        });
    });

    document.getElementById("contactForm1").addEventListener("submit", function(e) {
        e.preventDefault();

        let formData = new FormData(this);

        fetch(this.action, {
                method: "POST",
                body: formData,
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    document.getElementById("successMessage").style.display = "block";
                }
            })
            .catch(error => console.error("Error:", error));
    });

    document.addEventListener("DOMContentLoaded", function() {
        let contactModal = document.getElementById("contactForm");

        contactModal.addEventListener("shown.bs.modal", function() {
            let form = document.getElementById("contactForm1");

            // Assuming user details are available in JavaScript variables
            let userName = "{{ auth()->user()->name ?? '' }}";
            let userPhone = "{{ auth()->user()->phone ?? '' }}";
            let userEmail = "{{ auth()->user()->email ?? '' }}";

            form.querySelector('input[name="name"]').value = userName;
            form.querySelector('input[name="phone"]').value = userPhone;
            form.querySelector('input[name="email"]').value = userEmail;

            // Auto-submit the form after filling details
            setTimeout(() => {
                form.submit();
            }, 1000); // 1 second delay before submission
        });
    });
</script>
@endPushOnce