
<div class="header  {{ request()->path() == '/' ? 'header-transparent change-logo' : 'header-light head-shadow' }}">
    <div class="container">
        <nav id="navigation" class="navigation navigation-landscape">
            <div class="nav-header">
                @if ( request()->path() == '/')
                    <a class="nav-brand static-logo" href="{{ route('front.index') }}"><img src="{{ asset('assets/images/'.$gs->footer_logo) }}" class="logo" alt="" /></a>
                    <a class="nav-brand fixed-logo" href="{{ route('front.index') }}"><img src="{{ asset('assets/images/'.$gs->logo) }}" class="logo" alt="" /></a>
                @else
                    <a class="nav-brand" href="{{ route('front.index') }}">
                        <img src="{{ asset('assets/images/'.$gs->logo) }}" class="logo" alt="" />
                    </a>
                @endif
                <div class="nav-toggle"></div>
            </div>
            <div class="nav-menus-wrapper" style="transition-property: none;">
                <ul class="nav-menu">

                    <li class="{{ request()->routeIs('front.index') ? 'active' : '' }}">
                        <a href="{{ url('/') }}">@lang('Home')</a>
                    </li>

                    <li class="{{ request()->routeIs('front.invests') ? 'active' : '' }}">
                        <a href="{{ route('front.invests') }}">@lang('Invest Properties')</a>
                    </li>

                 
                     <li class="{{ request()->routeIs('front.contact') ? 'active' : '' }}">
                        <a href="{{ route('front.contact') }}">@lang('Contact Us')</a>
                    </li>

                </ul>

                <ul class="nav-menu nav-menu-social align-to-right">
                    @guest
                        <li>
                            <a href="{{ route('user.otp') }}">
                                @lang('Login/Register')</a>
                        </li>
                    @endguest

                    @auth
                        <li><a href="JavaScript:Void(0);">@lang('My Account')<span class="submenu-indicator"></span></a>
                            <ul class="nav-dropdown nav-submenu">
                                @if(auth()->user()->user_type != 'user')
                                    <li><a href="{{ route('agent.dashboard') }}">@lang('Agent Dashboard')</a></li>
                                @else
                                    <li><a href="{{ route('user.dashboard') }}">@lang('User Dashboard')</a></li>
                                @endif
                                <li><a href="{{ route('user.change.password.form') }}">@lang('Change Password')</a></li>
                                <li><a href="{{ route('user.logout') }}">@lang('Sign Out')</a></li>
                            </ul>
                        </li>
                    @endauth

                    @guest
                        <li>
                            <li class="add-listing theme-bg">
                                <a href="{{ route('agent.agent-step-1') }}">@lang('Post Property')</a>
                            </li>
                        </li>
                    @endguest

                    @auth
                        <li class="add-listing theme-bg">
                            <a href="{{ route('agent.properties.step_1', ['id' => null]) }}">@lang('Post Property')</a>
                        </li>
                    @endauth
                </ul>
            </div>
        </nav>
    </div>
</div>
