@push('css')
    <style>
        .share-options {
            display: none;
            position: absolute;
            bottom: 40px;
            right: 0;
            background: #d8d5d5;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            border-radius: 5px;
            /* border: 1px solid #7a7171; */
            padding: 10px 20px;
            z-index: 999;
            min-width: 160px;
        }

        @media (max-width: 767.98px) {
            .property-img {
                position: static;
                width: 100%;
                height: auto;
                object-fit: contain;
            }
        }
    </style> 
@endpush
@forelse ($properties as $key => $data)
    <div class="col-lg-12 col-md-12">
        <a href="{{ route('front.property.details', $data->slug) }}">
            <div
                class="property-card d-flex flex-wrap flex-md-nowrap shadow-lg rounded-3 overflow-hidden position-relative m-4">
                <!-- Left Side: Property Image -->
                <div class="property-img position-relative ">
                    <img src="{{ asset('assets/images/' . $data->photo) }}" class="img-fluid" alt="Property Image"
                        style="object-fit: cover;">
                    <!-- Wishlist Icon -->
                    <div class="wishlist-icon position-absolute top-0 end-0 p-2">
                        <a href="JavaScript:Void(0);" id="wishList"
                            class="{{ $data->checkFavourite(auth()->id(), $data->id) ? 'like-bitt' : '' }} add-to-favorite"
                            data-property="{{ $data->id }}" data-user="{{ auth()->id() }}" data-bs-toggle="tooltip"
                            data-original-title="Add To Favorites">
                            <i class="lni-heart-filled"></i>
                        </a>
                    </div>
                    <!-- Rating -->
                    @if ($data->reviews->count() > 0)
                        <div class="listing-rating position-absolute bottom-0 start-0 p-2 bg-dark text-white rounded">
                            @php
                                $review = $data->reviews->sum('rate') / $data->reviews->count();
                            @endphp
                            @for ($i = 1; $i <= $review; $i++)
                                <i class="ti-star filled text-warning"></i>
                            @endfor
                            @if (is_float($review))
                                <i class="ti-star text-warning"></i>
                            @endif
                        </div>
                    @endif
                    <!-- Property Type Label -->
                    <span class="property-type position-absolute top-0 start-0 p-1 bg-primary small text-white rounded">
                        {{ $data->looking_for == 'for_rent' ? __('For Rent') : __('For Sell') }}
                    </span>
                </div>
                <!-- Right Side: Property Details -->
                <div class="property-details px-4 flex-grow-1" style="width: 50%;">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="property-price mt-4" style="color: #3936f8">{{ showAmount($data->price) ?? '' }}</h4>
                        <!-- Share Button -->
                        <svg class="mt-2" xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="24"
                            height="22" viewBox="0 0 30 30" style="fill:#474646;"
                            onclick="toggleShareOptions(event, '{{ $data->id }}')">
                            <path
                                d="M 23 3 C 20.791 3 19 4.791 19 7 C 19 7.2869826 19.034351 7.5660754 19.091797 7.8359375L 10 12.380859 C 9.2667379 11.541629 8.2018825 11 7 11 C 4.791 11 3 12.791 3 15 C 3 17.209 4.791 19 7 19 C 8.2018825 19 9.2667379 18.458371 10 17.619141 L 19.091797 22.164062 C 19.034351 22.433925 19 22.713017 19 23 C 19 25.209 20.791 27 23 27 C 25.209 27 27 25.209 27 23 C 27 20.791 25.209 19 23 19 C 21.798117 19 20.733262 19.541629 20 20.380859 L 10.908203 15.835938 C 10.965649 15.566075 11 15.286983 11 15 C 11 14.713017 10.965649 14.433925 10.908203 14.164062 L 20 9.6191406 C 20.733262 10.458371 21.798117 11 23 11 C 25.209 11 27 9.209 27 7 C 27 4.791 25.209 3 23 3 z">
                            </path>
                        </svg>
                        <!-- Share Options -->
                        <div class="share-options" id="shareOptions-{{ $data->id }}" style="display: none;">
                            <a href="#"
                                onclick="copyLink('{{ route('front.property.details', $data->slug) }}')"><i
                                    class="ti-link"></i>&nbsp;&nbsp; Copy Link &nbsp;</a>
                            <a href="#"
                                onclick="share('whatsapp', '{{ route('front.property.details', $data->slug) }}')"><i
                                    class="fa-brands fa-whatsapp"></i>&nbsp;&nbsp; WhatsApp &nbsp;</a>
                            <a href="#"
                                onclick="share('instagram', '{{ route('front.property.details', $data->slug) }}')"><i
                                    class="ti-instagram"></i>&nbsp;&nbsp; Instagram &nbsp;</a>
                            <a href="#"
                                onclick="share('facebook', '{{ route('front.property.details', $data->slug) }}')"><i
                                    class="ti-facebook"></i>&nbsp;&nbsp; Facebook &nbsp;</a>
                            <a href="#"
                                onclick="share('twitter', '{{ route('front.property.details', $data->slug) }}')"><i
                                    class="fa-brands fa-x"></i>&nbsp;&nbsp; Twitter &nbsp;</a>
                            <a href="#"
                                onclick="share('linkedin', '{{ route('front.property.details', $data->slug) }}')"><i
                                    class="ti-linkedin"></i>&nbsp;&nbsp; Linkedin &nbsp;</a>
                        </div>
                    </div>
                    <div class="d-flex align-items-center justify-content-between mb-2">
                        <div>
                            <h5 class="property-title mt-2">{{ $data->name ?? '' }}</h5>
                            <p class="property-location ">
                                <i class="ti-location-pin"></i> {{ $data->locality ?? '' }},
                                {{ $data->location->name ?? '' }}
                            </p>
                        </div>
                        <div class="ms-auto text-end">
                            <span>{{ $data->user->name ?? '' }}</span><br>
                            <small class="">{{ $data->user->user_type ?? '' }}</small>
                        </div>
                    </div>
                    <!--<hr>-->
                    <!-- Features -->
                    <div class="property-features row g-2  mt-3">
                        @if ($data->category_id != 33)
                            @if ($data->no_of_bhk)
                                <div class="col-6 col-md-4 col-lg mb-2">
                                    <div>
                                        <p class="mb-0 small"><i class="fa-solid fa-bed mb-1"></i> No. Of BHK</p>
                                        <small>{{ $data->no_of_bhk }}</small>
                                    </div>
                                </div>
                            @endif

                            @if ($data->furnish_type && $data->looking_for = 'for_rent')
                                <div class="col-6 col-md-4 col-lg mb-2">
                                    <div>
                                        <p class="mb-0 small"><i class="fa-solid fa-tools mb-1 me-1"></i>Furnishing Status
                                        </p>
                                        <small>{{ ucwords(str_replace('-', ' ', $data->furnish_type)) }}</small>
                                    </div>
                                </div>
                            @endif
                            @if ($data->construction_status && $data->looking_for = 'for_sell')
                                <div class="col-6 col-md-4 col-lg mb-2">
                                    <div>
                                        <p class="mb-0 small"><i class="fa-solid fa-tools mb-1"></i> Construction Status
                                        </p>
                                        <small>{{ ucwords(str_replace('-', ' ', $data->construction_status)) }}</small>
                                    </div>
                                </div>
                            @endif

                            @if ($data->construction_status == 'under-construction' && $data->possession_date)
                                <div class="col-6 col-md-4 col-lg mb-2">
                                    <div>
                                        <p class="mb-0 small"><i class="bi bi-calendar-check mb-1"></i> Possession Date
                                        </p>
                                        <small>{{ $data->possession_date }}</small>
                                    </div>
                                </div>
                            @elseif ($data->construction_status == 'ready-to-move' && $data->property_age)
                                <div class="col-6 col-md-4 col-lg mb-2">
                                    <div>
                                        <p class="mb-0 small"><i class="fa-solid fa-calendar-alt mb-1"></i> Property Age
                                        </p>
                                        <small>{{ $data->property_age }}
                                            {{ $data->property_age == 1 ? 'Year' : 'Years' }}</small>
                                    </div>
                                </div>
                            @endif
                            @if ($data->sale_type)
                                <div class="col-6 col-md-4 col-lg mb-2">
                                    <div>
                                        <p class="mb-0 small"><i class="fa-solid fa-file-signature mb-1"></i> Booking
                                            Type</p>
                                        <small>{{ ucfirst(str_replace('-', ' ', $data->sale_type)) }}</small>
                                    </div>
                                </div>
                            @endif
                            @if ($data->carpet_area)
                                <div class="col-6 col-md-4 col-lg mb-2">
                                    <div>
                                        <p class="mb-0 small"><i class="fa-solid fa-maximize mb-1"></i> Carpet Area</p>
                                        <small>{{ $data->carpet_area . ' ' . $data->area_unit }}</small>
                                    </div>
                                </div>
                            @endif

                            @if ($data->price_per_sqft)
                                <div class="col-6 col-md-4 col-lg mb-2">
                                    <div>
                                        <p class="mb-0 small"><i class="fa-solid fa-indian-rupee-sign mb-1"></i> Price
                                            Per {{ ucwords($data->area_unit) }}</p>
                                        <small>₹{{ $data->price_per_sqft }}</small>
                                    </div>
                                </div>
                            @endif
                        @endif
                        @if (in_array($data->category_id, [32, 33]))
                            @if ($data->possession_status)
                                <div class="col-6 col-md-4 col-lg mb-2">
                                    <div>
                                        <p class="mb-0 small"><i class="fa-solid fa-flag-checkered mb-1"></i> Possession
                                            Status</p>
                                        <small>
                                            {{ $data->possession_status == 'future' ? 'In ' . ucwords($data->possession_status) : ucwords($data->possession_status) }}
                                        </small>
                                    </div>
                                </div>
                            @endif
                            @if ($data->possession_status == 'future')
                                <div class="col-6 col-md-4 col-lg mb-2">
                                    <div>
                                        <p class="mb-0 small"><i class="fa-solid fa-calendar-days mb-1"></i> Available
                                            From</p>
                                        <small>{{ $data->possession_date }}</small>
                                    </div>
                                </div>
                            @endif
                            @if ($data->construction_type)
                                <div class="col-6 col-md-4 col-lg mb-2">
                                    <div>
                                        <p class="mb-0 small"><i class="fa-solid fa-hammer mb-1"></i> Construction Type
                                        </p>
                                        <small>{{ ucwords($data->construction_type) }}</small>
                                    </div>
                                </div>
                            @endif
                            @if ($data->plot_area)
                                <div class="col-6 col-md-4 col-lg mb-2">
                                    <div>
                                        <p class="mb-0 small"><i class="fa-solid fa-vector-square mb-1"></i> Plot Area
                                        </p>
                                        <small>{{ $data->plot_area . ' ' . $data->area_unit }}</small>
                                    </div>
                                </div>
                            @endif
                            @if ($data->plot_length && $data->plot_width)
                                <div class="col-6 col-md-4 col-lg mb-2">
                                    <div>
                                        <p class="mb-0 small">
                                            <i class="ti-ruler-pencil mb-1"></i> Plot Dimensions
                                        </p>
                                        <small>{{ $data->plot_length . ' X ' . $data->plot_width }}</small>
                                    </div>
                                </div>
                            @endif
                            @if ($data->ownership)
                                <div class="col-6 col-md-4 col-lg mb-2">
                                    <div>
                                        <p class="mb-0 small"><i class="fa-solid fa-id-badge mb-1"></i> Ownership</p>
                                        <small>{{ ucwords(str_replace('-', ' ', $data->ownership)) }}</small>
                                    </div>
                                </div>
                            @endif
                        @endif
                    </div>
                    <!-- CTA Buttons -->
                    <div class="d-flex gap-1 flex-nowrap py-4">
                        <button class="btn btn-primary btn-sm flex-grow-1 custom-btn">
                            <a class="text-light"
                                href="{{ route('front.property.details', $data->slug) }}">@lang('More Info')</a>
                        </button>
                        @if ($data->admin)
                            @auth
                                <button class="btn btn-primary btn-sm flex-grow-1 custom-btn"
                                    onclick="showContactModal('{{ $data->admin->name }}', '{{ $data->admin->phone }}')">
                                    View Contact
                                </button>
                            @else
                                <button class="btn border border-dark text-dark btn-sm flex-grow-1 custom-btn"
                                    onclick="redirectToLogin()">
                                    View Contact
                                </button>
                            @endauth
                        @else
                            @if ($data->user)
                                @auth
                                    <button class="btn btn-primary btn-sm flex-grow-1 custom-btn"
                                        onclick="showContactModal('{{ $data->user->name }}', '{{ $data->user->phone }}')">
                                        View Contact
                                    </button>
                                @else
                                    <button class="btn btn-primary btn-sm flex-grow-1 custom-btn"
                                        onclick="redirectToLogin()">
                                        View Contact
                                    </button>
                                @endauth
                            @endif
                        @endif
                        @if ($data->user)
                            @auth
                                <button class="btn btn-primary btn-sm flex-grow-1 custom-btn" data-bs-toggle="modal"
                                    data-bs-target="#contactForm">Contact {{ $data->user->user_type }}</button>
                            @else
                                <button class="btn btn-primary btn-sm flex-grow-1 custom-btn" onclick="redirectToLogin()">
                                    Contact Seller
                                </button>
                            @endauth
                        @endif
                    </div>
                    <!-- Modal -->
                    <div class="modal fade" id="contactModal" tabindex="-1" role="dialog"
                        aria-labelledby="contactModalLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="contactModalLabel">Contact Details</h5>
                                    <button type="button" class="close" data-bs-dismiss="modal"
                                        aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <p><strong>Name:</strong> <span id="contactName"></span></p>
                                    <p><strong>Phone:</strong> <span id="contactPhone"></span></p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary modal-close-btn"
                                        data-bs-dismiss="modal">Close</button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Contact Modal -->
                    <div class="modal fade" id="contactForm" tabindex="-1" aria-labelledby="contactFormLabel"
                        aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="contactFormLabel">Contact Seller</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <div id="successMessage" style="text-align:center;">
                                        <img src="{{ asset('assets/images/success-icon-10.png') }}" alt="Success"
                                            width="50">
                                        <p>Seller details are now available in the <a href="#">contacted
                                                properties</a> section of the profile page.</p>
                                    </div>
                                    <form id="contactForm1" action="{{ route('user.property.enquiry') }}"
                                        method="post">
                                        @csrf
                                        <input type="hidden" name="property_id" value="{{ $data->id }}">
                                        <input type="hidden" name="name">
                                        <input type="hidden" name="phone">
                                        <input type="hidden" name="email">
                                        <input type="hidden" name="property_owner_id"
                                            value="{{ $data->property ? $data->user_id : '' }}">
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </a>
    </div>
@empty
    <p>No properties found.</p>
@endforelse
<div class="row">
    <div class="col-lg-12 col-md-12 col-sm-12">
        @if ($properties->hasPages())
            {{ $properties->links() }}
        @endif
    </div>
</div>
<script>
    function showLoginPrompt() {
        alert('You need to log in to view contact details.');
        window.location.href = "{{ route('user.otp') }}";
    }

    function showContactModal(name, phone) {
        document.getElementById('contactName').innerText = name;
        document.getElementById('contactPhone').innerText = phone;
        $('#contactModal').modal('show');
    }

    function closeModal() {
        $('#contactModal').modal('hide');
    }

    function redirectToLogin() {
        window.location.href = "{{ route('user.otp') }}";
    }
    $(document).on('click', '.modal-close-btn', function() {
        closeModal();
    });
    $(document).on('click', '#wishList', function() {
        let $this = $(this);
        let propertyId = $(this).data('property');
        let userId = $(this).data('user');
        if (userId == '') {
            window.location.href = mainurl + '/user/login';
        }
        $.ajax({
            method: "POST",
            url: mainurl + '/property/wishlist',
            data: {
                property_id: propertyId,
                user_id: userId
            },
            success: function(data) {
                if (data.success) {
                    $this.prop('class', '');
                    $this.prop('class', 'like-bitt add-to-favorite');
                    toastr.success(data.success);
                } else {
                    $this.prop('class', '');
                    $this.prop('class', 'add-to-favorite');
                    toastr.error(data.error);
                }
            }
        });
    });

    function toggleShareOptions(event, propertyId) {
        event.preventDefault();
        var shareOptions = document.getElementById('shareOptions-' + propertyId);
        shareOptions.style.display = (shareOptions.style.display === 'none' || shareOptions.style.display === '') ?
            'block' : 'none';
        setTimeout(function() {
            shareOptions.style.display = 'none';
        }, 3000);
    }

    function share(platform, url) {
        let text = "Check this out!";
        let shareUrl = "";
        switch (platform) {
            case 'facebook':
                shareUrl = `https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(url)}`;
                break;
            case 'twitter':
                shareUrl =
                    `https://twitter.com/intent/tweet?text=${encodeURIComponent(text)}&url=${encodeURIComponent(url)}`;
                break;
            case 'instagram':
                shareUrl = `https://www.instagram.com/?url=${encodeURIComponent(url)}`;
                break;
            case 'linkedin':
                shareUrl = `https://www.linkedin.com/sharing/share-offsite/?url=${encodeURIComponent(url)}`;
                break;
            case 'whatsapp':
                shareUrl = `https://wa.me/?text=${encodeURIComponent(text)}%20${encodeURIComponent(url)}`;
                break;
            default:
                console.log("Unsupported platform");
                return;
        }
        if (shareUrl) {
            window.open(shareUrl, '_blank', 'noopener,noreferrer');
        }
    }

    function copyLink(url) {
        navigator.clipboard.writeText(url).then(function() {
            alert('Link copied to clipboard: ' + url);
        }, function(err) {
            console.error('Could not copy text: ', err);
        });
    }
    document.addEventListener("DOMContentLoaded", function() {
        var closeModalBtns = document.querySelectorAll('[data-bs-dismiss="modal"]');
        closeModalBtns.forEach(function(btn) {
            btn.addEventListener('click', function() {
                var myModalEl = document.getElementById('contactForm');
                var modalInstance = bootstrap.Modal.getInstance(myModalEl);
                modalInstance.hide();
            });
        });
    });

    document.getElementById("contactForm1").addEventListener("submit", function(e) {
        e.preventDefault();

        let formData = new FormData(this);

        fetch(this.action, {
                method: "POST",
                body: formData,
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    document.getElementById("successMessage").style.display = "block";
                }
            })
            .catch(error => console.error("Error:", error));
    });

    document.addEventListener("DOMContentLoaded", function() {
        let contactModal = document.getElementById("contactForm");

        contactModal.addEventListener("shown.bs.modal", function() {
            let form = document.getElementById("contactForm1");

            // Assuming user details are available in JavaScript variables
            let userName = "{{ auth()->user()->name ?? '' }}";
            let userPhone = "{{ auth()->user()->phone ?? '' }}";
            let userEmail = "{{ auth()->user()->email ?? '' }}";

            form.querySelector('input[name="name"]').value = userName;
            form.querySelector('input[name="phone"]').value = userPhone;
            form.querySelector('input[name="email"]').value = userEmail;

            // Auto-submit the form after filling details
            setTimeout(() => {
                form.submit();
            }, 1000); // 1 second delay before submission
        });
    });
</script>
