@pushOnce('css')
<style>
    .share-options {
        display: none;
        position: absolute;
        bottom: 40px;
        right: 0;
        background: #d8d5d5;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        border-radius: 5px;
        /* border: 1px solid #7a7171; */
        padding: 10px 20px;
        z-index: 999;
        min-width: 160px;
    }

    @media (max-width: 767.98px) {
        .property-img {
            position: static;
            width: 100%;
            height: auto;
            object-fit: contain;
        }
    }
</style>
@endPushOnce
@forelse ($properties as $key => $data)
<div class="col-lg-12 col-md-12">
    <a href="{{ route('buy.details', $data->slug) }}" target="_blank">
        <div
            class="property-card d-flex flex-wrap flex-md-nowrap shadow-lg rounded-3 overflow-hidden position-relative m-4">
            <!-- Left Side: Property Image -->
            <div class="property-img position-relative ">
                <img src="{{ asset('assets/images/' . $data->photo) }}" class="img-fluid" alt="Property Image"
                    style="object-fit: cover;">
                <!-- Wishlist Icon -->
                <div class="wishlist-icon position-absolute top-0 end-0 p-2">
                    <a href="JavaScript:Void(0);" id="wishList"
                        class="{{ $data->checkFavourite(auth()->id(), $data->id) ? 'like-bitt' : '' }} add-to-favorite"
                        data-property="{{ $data->id }}" data-user="{{ auth()->id() }}" data-bs-toggle="tooltip"
                        data-original-title="Add To Favorites">
                        <i class="lni-heart-filled"></i>
                    </a>
                </div>
                <!-- Rating -->
                @if ($data->reviews->count() > 0)
                <div class="listing-rating position-absolute bottom-0 start-0 p-2 bg-dark text-white rounded">
                    @php
                    $review = $data->reviews->sum('rate') / $data->reviews->count();
                    @endphp
                    @for ($i = 1; $i <= $review; $i++)
                        <i class="ti-star filled text-warning"></i>
                        @endfor
                        @if (is_float($review))
                        <i class="ti-star text-warning"></i>
                        @endif
                </div>
                @endif
                <!-- Property Type Label -->
                <span class="property-type position-absolute top-0 start-0 p-1 bg-primary small text-white rounded">
                    For Sell
                     @if (!empty($isSponsored))
                        . Sponsored
                    @endif
                </span>
            </div>
            <!-- Right Side: Property Details -->
            <div class="property-details px-4 flex-grow-1" style="width: 50%;">
                @if ($data->user->user_type == 'builder/developer')
                <div class="d-flex justify-content-between align-items-center">
                    <h4 class="property-price mt-4">{{ $data->name ?? '' }}
                    </h4>
                   
                    <!-- Share Button -->
                    <svg class="mt-2" xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="24"
                        height="22" viewBox="0 0 30 30" style="fill:#474646;"
                        onclick="toggleShareOptions(event, '{{ $data->id }}')">
                        <path
                            d="M 23 3 C 20.791 3 19 4.791 19 7 C 19 7.2869826 19.034351 7.5660754 19.091797 7.8359375L 10 12.380859 C 9.2667379 11.541629 8.2018825 11 7 11 C 4.791 11 3 12.791 3 15 C 3 17.209 4.791 19 7 19 C 8.2018825 19 9.2667379 18.458371 10 17.619141 L 19.091797 22.164062 C 19.034351 22.433925 19 22.713017 19 23 C 19 25.209 20.791 27 23 27 C 25.209 27 27 25.209 27 23 C 27 20.791 25.209 19 23 19 C 21.798117 19 20.733262 19.541629 20 20.380859 L 10.908203 15.835938 C 10.965649 15.566075 11 15.286983 11 15 C 11 14.713017 10.965649 14.433925 10.908203 14.164062 L 20 9.6191406 C 20.733262 10.458371 21.798117 11 23 11 C 25.209 11 27 9.209 27 7 C 27 4.791 25.209 3 23 3 z">
                        </path>
                    </svg>
                    <!-- Share Options -->
                    <div class="share-options" id="shareOptions-{{ $data->id }}" style="display: none;">
                        <a href="#" onclick="copyLink('{{ route('buy.details', $data->slug) }}')"><i
                                class="ti-link"></i>&nbsp;&nbsp; Copy Link &nbsp;</a>
                        <a href="#"
                            onclick="share('whatsapp', '{{ route('buy.details', $data->slug) }}')"><i
                                class="fa-brands fa-whatsapp"></i>&nbsp;&nbsp; WhatsApp &nbsp;</a>
                        <a href="#"
                            onclick="share('instagram', '{{ route('buy.details', $data->slug) }}')"><i
                                class="ti-instagram"></i>&nbsp;&nbsp; Instagram &nbsp;</a>
                        <a href="#"
                            onclick="share('facebook', '{{ route('buy.details', $data->slug) }}')"><i
                                class="ti-facebook"></i>&nbsp;&nbsp; Facebook &nbsp;</a>
                        <a href="#"
                            onclick="share('twitter', '{{ route('buy.details', $data->slug) }}')"><i
                                class="fa-brands fa-x"></i>&nbsp;&nbsp; Twitter &nbsp;</a>
                        <a href="#"
                            onclick="share('linkedin', '{{ route('buy.details', $data->slug) }}')"><i
                                class="ti-linkedin"></i>&nbsp;&nbsp; Linkedin &nbsp;</a>
                    </div>
                </div>
                <div class="d-flex align-items-center justify-content-between mb-2">
                    <div>
                        <h5 class="mt-2">
                            @php
                            $bhkTypes = $data->floorplans->pluck('name')->map(function($name) {
                            preg_match('/(\d+)/', $name, $matches);
                            return $matches[1] ?? null;
                            })->filter()->unique()->sort()->values();

                            $bhkDisplay = $bhkTypes->implode(', ');
                            @endphp

                            {{ $bhkTypes->count() > 1 
                                        ? "{$bhkDisplay} BHK Flats in " . ucwords($data->location->name ?? '') 
                                        : "{$bhkDisplay} BHK Flat in " . ucwords($data->location->name ?? '') }}
                        </h5>
                        <p class="property-location text-dark">
                            <i class="ti-location-pin"></i> {{ ucwords(strtolower($data->locality)) ?? '' }},
                            {{ ucwords($data->location->name) ?? '' }}
                        </p>
                    </div>
                    <div class="ms-auto text-end text-dark">
                        <span>{{ ucwords($data->user->name) ?? '' }}</span><br>
                        <span class="">{{ strtolower($data->user->user_type) == 'builder/developer' ? 'Developer' : ucwords($data->user->user_type) }}</span>
                    </div>
                </div>
                @php
                // Custom sort logic:
                $sortedPlans = $data->floorplans->sort(function($a, $b) {
                // RK check
                if (stripos($a->name, 'rk') !== false) return -1;
                if (stripos($b->name, 'rk') !== false) return 1;

                // Extract BHK numbers
                preg_match('/\d+/', $a->name, $aMatch);
                preg_match('/\d+/', $b->name, $bMatch);

                $aBHK = isset($aMatch[0]) ? (int)$aMatch[0] : 0;
                $bBHK = isset($bMatch[0]) ? (int)$bMatch[0] : 0;

                return $aBHK <=> $bBHK;
                    });
                    @endphp

                    <div class="d-flex flex-wrap align-items-center gap-3 mt-3">
                        @foreach ($sortedPlans as $plan)
                        <div class="d-flex align-items-center">
                            <div class="me-2 text-center">
                                <p class="mb-0">{{ strtoupper(str_replace('-', ' ', $plan->name)) }} Flat</p>
                                <span class="fw-bold text-dark">₹{{ (int) $plan->expected_price }}</span>
                            </div>
                            @if (!$loop->last)
                            <div style="width: 1px; height: 40px; background-color: #ccc;" class="mx-3"></div>
                            @endif
                        </div>
                        @endforeach
                    </div>


                    <div class="d-flex flex-wrap align-items-center gap-4 mt-2">
                        @php
                        $price = null;
                        if (!$price) {
                        $prices = $data->floorplans->pluck('price_per_sqft')->filter()->unique()->sort()->values();
                        $minPrice = $prices->first();
                        $maxPrice = $prices->last();
                        }
                        $sizes = $data->floorplans->pluck('built_up_area')->filter()->unique()->sort();
                        @endphp

                        <div>
                            <strong>Avg. Price:</strong>
                            @if ($bhk && isset($price))
                            ₹{{ (int) $price }}/{{$data->area_unit == 'sqft' ? 'Sq.Ft' : 'Sq.Mtr'}}
                            @elseif (isset($minPrice) && isset($maxPrice))
                            ₹{{ (int) $minPrice }}{{ $minPrice != $maxPrice ? ' - ₹' . (int) $maxPrice : '' }}/{{$data->area_unit == 'sqft' ? 'Sq.Ft' : 'Sq.Mtr'}}
                            @else
                            Not available
                            @endif
                        </div>
                        <div>
                            <strong>Sizes:</strong>
                            {{ $sizes->map(fn($s) => $s . ' ' . ($data->area_unit == 'sqft' ? 'Sq.Ft' : 'Sq.Mtr'))->implode(', ') }}
                        </div>

                        <div>
                            <strong>Status:</strong> {{ ucfirst($data->construction_status) }}
                        </div>

                        <div>
                            <strong>Possession:</strong>
                            {{ date('d-m-Y', strtotime($data->possession_date)) }}
                        </div>
                    </div>
                    @else
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="property-price mt-4" style="color: #3936f8">{{ showAmount($data->price) ?? '' }}
                        </h4>
                        <!-- Share Button -->
                        <svg class="mt-2" xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="24"
                            height="22" viewBox="0 0 30 30" style="fill:#474646;"
                            onclick="toggleShareOptions(event, '{{ $data->id }}')">
                            <path
                                d="M 23 3 C 20.791 3 19 4.791 19 7 C 19 7.2869826 19.034351 7.5660754 19.091797 7.8359375L 10 12.380859 C 9.2667379 11.541629 8.2018825 11 7 11 C 4.791 11 3 12.791 3 15 C 3 17.209 4.791 19 7 19 C 8.2018825 19 9.2667379 18.458371 10 17.619141 L 19.091797 22.164062 C 19.034351 22.433925 19 22.713017 19 23 C 19 25.209 20.791 27 23 27 C 25.209 27 27 25.209 27 23 C 27 20.791 25.209 19 23 19 C 21.798117 19 20.733262 19.541629 20 20.380859 L 10.908203 15.835938 C 10.965649 15.566075 11 15.286983 11 15 C 11 14.713017 10.965649 14.433925 10.908203 14.164062 L 20 9.6191406 C 20.733262 10.458371 21.798117 11 23 11 C 25.209 11 27 9.209 27 7 C 27 4.791 25.209 3 23 3 z">
                            </path>
                        </svg>
                        <!-- Share Options -->
                        <div class="share-options" id="shareOptions-{{ $data->id }}" style="display: none;">
                            <a href="#" onclick="copyLink('{{ route('buy.details', $data->slug) }}')"><i
                                    class="ti-link"></i>&nbsp;&nbsp; Copy Link &nbsp;</a>
                            <a href="#"
                                onclick="share('whatsapp', '{{ route('buy.details', $data->slug) }}')"><i
                                    class="fa-brands fa-whatsapp"></i>&nbsp;&nbsp; WhatsApp &nbsp;</a>
                            <a href="#"
                                onclick="share('instagram', '{{ route('buy.details', $data->slug) }}')"><i
                                    class="ti-instagram"></i>&nbsp;&nbsp; Instagram &nbsp;</a>
                            <a href="#"
                                onclick="share('facebook', '{{ route('buy.details', $data->slug) }}')"><i
                                    class="ti-facebook"></i>&nbsp;&nbsp; Facebook &nbsp;</a>
                            <a href="#"
                                onclick="share('twitter', '{{ route('buy.details', $data->slug) }}')"><i
                                    class="fa-brands fa-x"></i>&nbsp;&nbsp; Twitter &nbsp;</a>
                            <a href="#"
                                onclick="share('linkedin', '{{ route('buy.details', $data->slug) }}')"><i
                                    class="ti-linkedin"></i>&nbsp;&nbsp; Linkedin &nbsp;</a>
                        </div>
                    </div>
                    <div class="d-flex align-items-center justify-content-between mb-2">
                        <div>
                            <h5 class="property-title mt-2">{{ ucwords($data->name) ?? '' }}</h5>
                            <p class="property-location text-dark">
                                <i class="ti-location-pin"></i> {{ ucwords(strtolower($data->locality)) ?? '' }},
                                {{ ucwords($data->location->name) ?? '' }}
                            </p>
                        </div>
                        <div class="ms-auto text-end text-dark">
                            <span>{{ ucwords($data->user->name) ?? '' }}</span><br>
                            <span class="">{{ strtolower($data->user->user_type) == 'builder/developer' ? 'Developer' : ucwords($data->user->user_type) }}</span>
                        </div>
                    </div>
                    <!-- Features -->
                    <div class="property-features row g-2  mt-3">

                        @if ($data->no_of_bhk)
                        <div class="col-6 col-md-4 col-lg mb-2">
                            <div>
                                <p class="mb-0 small"> No. Of BHK</p>
                                <small>{{ strtoupper(str_replace('-', ' ', $data->no_of_bhk)) }}</small>
                            </div>
                        </div>
                        @endif

                        @if ($data->construction_status)
                        <div class="col-6 col-md-4 col-lg mb-2">
                            <div>
                                <p class="mb-0 small">Construction
                                    Status
                                </p>
                                <small>{{ ucwords(str_replace('-', ' ', $data->construction_status)) }}</small>
                            </div>
                        </div>
                        @endif

                        @if ($data->construction_status == 'under-construction' && $data->possession_date)
                        <div class="col-6 col-md-4 col-lg mb-2">
                            <div>
                                <p class="mb-0 small">Possession
                                    Date
                                </p>
                                <small>{{ date('d-m-Y', strtotime($data->possession_date)) }}</small>
                            </div>
                        </div>
                        @elseif ($data->construction_status == 'ready-to-move' && $data->property_age)
                        <div class="col-6 col-md-4 col-lg mb-2">
                            <div>
                                <p class="mb-0 small">Property
                                    Age
                                </p>
                                <small>{{ $data->property_age }}
                                    {{ $data->property_age == 1 ? 'Year' : 'Years' }}</small>
                            </div>
                        </div>
                        @endif
                        @if ($data->sale_type)
                        <div class="col-6 col-md-4 col-lg mb-2">
                            <div>
                                <p class="mb-0 small">
                                    Booking
                                    Type</p>
                                <small>{{ ucfirst(str_replace('-', ' ', $data->sale_type)) }}</small>
                            </div>
                        </div>
                        @endif
                        @if ($data->carpet_area)
                        <div class="col-6 col-md-4 col-lg mb-2">
                            <div>
                                <p class="mb-0 small"> Carpet Area
                                </p>
                                <small>{{ $data->carpet_area  }} {{$data->area_unit == 'sqft' ? 'Sq.Ft' : 'Sq.Mtr'}}</small>
                            </div>
                        </div>
                        @endif

                        @if ($data->price_per_sqft)
                        <div class="col-6 col-md-4 col-lg mb-2">
                            <div>
                                <p class="mb-0 small">
                                    Price
                                    Per {{ $data->area_unit == 'sqft' ? 'Sq.Ft' : 'Sq.Mtr' }}</p>
                                <small>₹{{ $data->price_per_sqft }}</small>
                            </div>
                        </div>
                        @endif
                    </div>
                    @endif

                    <!-- CTA Buttons -->
                    <div class="d-flex gap-1 flex-nowrap py-4">
                        <!-- More Info Button -->
                        <a href="{{ route('buy.details', $data->slug) }}" target="_blank"
                            class="btn btn-primary btn-sm flex-grow-1 custom-btn text-light text-center">
                            @lang('More Info')
                        </a>

                        @if ($data->user)
                        @auth
                        <!-- View Contact Button -->
                        <button type="button"
                            class="btn btn-primary btn-sm w-25 custom-btn"
                            onclick="viewContact('{{ $data->id }}', '{{ $data->user->name }}', '{{ $data->user->phone }}')">
                            View Contact
                        </button>

                        <!-- Modal -->
                        <div class="modal fade" id="contactModal" tabindex="-1" role="dialog"
                            aria-labelledby="contactModalLabel" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="contactModalLabel">Contact Details</h5>
                                        <button type="button" class="close" data-bs-dismiss="modal"
                                            aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body">
                                        <p><strong>Name:</strong> <span id="contactName"></span></p>
                                        <p><strong>Phone:</strong> <span id="contactPhone"></span></p>
                                        <div id="contactAlert"></div>
                                    </div>
                                
                                </div>
                            </div>
                        </div>

                        <script>
                            function viewContact(propertyId, name, phone) {
                                // Show modal first (optimistic UI)
                                document.getElementById('contactName').innerText = name;
                                document.getElementById('contactPhone').innerText = '+91-' + phone;
                                $('#contactModal').modal('show');

                                // Send AJAX request to log the view
                                $.ajax({
                                    url: "{{ route('property.viewContact') }}",
                                    type: "POST",
                                    data: {
                                        _token: "{{ csrf_token() }}",
                                        property_id: propertyId,
                                        contact_type: 'view_contact'
                                    },
                                    success: function(response) {
                                        let alertBox = document.getElementById('contactAlert');
                                        alertBox.innerHTML = `<div class="alert alert-${response.status} mt-2">${response.message}</div>`;
                                    },
                                    error: function(xhr) {
                                        let alertBox = document.getElementById('contactAlert');
                                        alertBox.innerHTML = `<div class="alert alert-danger mt-2">Something went wrong. Please try again.</div>`;
                                    }
                                });
                            }
                        </script>

                        @else
                        <button class="btn btn-primary btn-sm flex-grow-1 custom-btn w-100" onclick="redirectToLogin()">
                            View Contact
                        </button>
                        @endauth
                        @endif

                        @if ($data->user)
                        @auth
                        <!-- Enquiry / Contact Button -->
                        <form action="{{ route('property.viewContact') }}" method="POST" class="d-inline flex-grow-1">
                            @csrf
                            <input type="hidden" name="property_id" value="{{ $data->id }}">
                            <input type="hidden" name="contact_type" value="enquiry">
                            <button type="submit" data-bs-toggle="modal" data-bs-target="#contactForm"
                                class="btn btn-primary btn-sm w-100 custom-btn">
                                Contact {{ strtolower($data->user->user_type) == 'builder/developer' ? 'Developer' : ucwords($data->user->user_type) }}
                            </button>
                        </form>
                        @else
                        <button class="btn btn-primary btn-sm flex-grow-1 custom-btn w-100" onclick="redirectToLogin()">
                            Contact Seller
                        </button>
                        @endauth
                        @endif
                    </div>

                    <!-- Modal -->
                    <div class="modal fade" id="contactModal" tabindex="-1" role="dialog"
                        aria-labelledby="contactModalLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="contactModalLabel">Contact Details</h5>
                                    <button type="button" class="close" data-bs-dismiss="modal"
                                        aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <p><strong>Name:</strong> <span id="contactName"></span></p>
                                    <p><strong>Phone:</strong> <span id="contactPhone"></span></p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary modal-close-btn"
                                        data-bs-dismiss="modal">Close</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Contact Modal -->
                    <div class="modal fade" id="contactForm" tabindex="-1" aria-labelledby="contactFormLabel"
                        aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="contactFormLabel">Contact Seller</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <div id="successMessage" style="text-align:center;">
                                        <img src="{{ asset('assets/images/success-icon-10.png') }}" alt="Success"
                                            width="50">
                                        <p>Seller details are now available in your user login dashboard.</p>
                                    </div>
                                    <form id="contactForm1" action="{{ route('user.property.enquiry') }}"
                                        method="post">
                                        @csrf
                                        <input type="hidden" name="property_id" value="{{ $data->id }}">
                                        <input type="hidden" name="name">
                                        <input type="hidden" name="phone">
                                        <input type="hidden" name="email">
                                        <input type="hidden" name="property_owner_id"
                                            value="{{ $data->property ? $data->user_id : '' }}">
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
            </div>
        </div>
    </a>
</div>

@empty
     @if (empty($isSponsored))
        <p>No properties found.</p>
    @endif
@endforelse

<div class="row">
    <div class="col-lg-12 col-md-12 col-sm-12">
        @if (method_exists($properties, 'hasPages') && $properties->hasPages())
        {{ $properties->links() }}
        @endif
    </div>
</div>

@pushOnce('js')
<script>
    function showLoginPrompt() {
        alert('You need to log in to view contact details.');
        window.location.href = "{{ route('user.otp') }}";
    }

    function showContactModal(name, phone) {
        document.getElementById('contactName').innerText = name;
        document.getElementById('contactPhone').innerText = '+91-' + phone;
        $('#contactModal').modal('show');
    }

    function closeModal() {
        $('#contactModal').modal('hide');
    }

    function redirectToLogin() {
        window.location.href = "{{ route('user.otp') }}";
    }
    $(document).on('click', '.modal-close-btn', function() {
        closeModal();
    });

    function toggleShareOptions(event, propertyId) {
        event.preventDefault();
        var shareOptions = document.getElementById('shareOptions-' + propertyId);
        shareOptions.style.display = (shareOptions.style.display === 'none' || shareOptions.style.display === '') ?
            'block' : 'none';
        setTimeout(function() {
            shareOptions.style.display = 'none';
        }, 3000);
    }

    function share(platform, url) {
        let text = "Check this out!";
        let shareUrl = "";
        switch (platform) {
            case 'facebook':
                shareUrl = `https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(url)}`;
                break;
            case 'twitter':
                shareUrl =
                    `https://twitter.com/intent/tweet?text=${encodeURIComponent(text)}&url=${encodeURIComponent(url)}`;
                break;
            case 'instagram':
                shareUrl = `https://www.instagram.com/?url=${encodeURIComponent(url)}`;
                break;
            case 'linkedin':
                shareUrl = `https://www.linkedin.com/sharing/share-offsite/?url=${encodeURIComponent(url)}`;
                break;
            case 'whatsapp':
                shareUrl = `https://wa.me/?text=${encodeURIComponent(text)}%20${encodeURIComponent(url)}`;
                break;
            default:
                console.log("Unsupported platform");
                return;
        }
        if (shareUrl) {
            window.open(shareUrl, '_blank', 'noopener,noreferrer');
        }
    }

    function copyLink(url) {
        navigator.clipboard.writeText(url).then(function() {
            alert('Link copied to clipboard: ' + url);
        }, function(err) {
            console.error('Could not copy text: ', err);
        });
    }
    document.addEventListener("DOMContentLoaded", function() {
        var closeModalBtns = document.querySelectorAll('[data-bs-dismiss="modal"]');
        closeModalBtns.forEach(function(btn) {
            btn.addEventListener('click', function() {
                var myModalEl = document.getElementById('contactForm');
                var modalInstance = bootstrap.Modal.getInstance(myModalEl);
                modalInstance.hide();
            });
        });
    });
</script>
@endPushOnce