@extends('layouts.user')
@push('css')
@endpush
@section('content')
    <!-- ============================ User Dashboard ================================== -->
    <div class="dashboard-wraper">
        <h6>Contacted Properties</h6>
        <div class="data-container mt-4">
            <div id="contacted-data" class="data-content">
                <h4>@lang('Contacted Properties')</h4>
                @if (empty($contactedProperties))
                    No data Available
                @else
                    @foreach ($contactedProperties as $contact)
                        @php
                            $property = $contact->property;
                        @endphp
                        @php
                            $routes = [
                                'for_pg' => 'pg.details',
                                'for_rent' => 'rent.details',
                                'for_sell' => 'buy.details',
                                'plot' => 'plot.details',
                                'commercial' => 'commercial.details',
                            ];

                            $propertyUrl = isset($routes[$property->looking_for])
                                ? route($routes[$property->looking_for], $property->slug)
                                : '#'; // fallback
                        @endphp
                        <div class="col-lg-12 col-md-12">
                            <a href="{{ $propertyUrl }}" target="_blank">
                                <div
                                    class="property-card d-flex flex-wrap flex-md-nowrap shadow-lg rounded-3 overflow-hidden position-relative pt-2">
                                    <div class="property-img position-relative ">
                                        <img src="{{ asset('assets/images/' . $property->photo) }}" class="img-fluid"
                                            alt="Property Image"
                                            style="object-fit: cover; max-width: 220px; max-height: 250px;">
                                        <!-- Wishlist Icon -->
                                        <div class="wishlist-icon position-absolute top-0 end-0 p-2">
                                            <a href="JavaScript:Void(0);" id="wishList"
                                                class="{{ $property->checkFavourite(auth()->id(), $property->id) ? 'like-bitt' : '' }} add-to-favorite"
                                                data-property="{{ $property->id }}" data-user="{{ auth()->id() }}"
                                                data-bs-toggle="tooltip" data-original-title="Add To Favorites">
                                                <i class="lni-heart-filled"></i>
                                            </a>
                                        </div>
                                        <!-- Rating -->
                                        @if ($property->reviews->count() > 0)
                                            <div
                                                class="listing-rating position-absolute bottom-0 start-0 p-2 bg-dark text-white rounded">
                                                @php
                                                    $review =
                                                        $property->reviews->sum('rate') / $property->reviews->count();
                                                @endphp
                                                @for ($i = 1; $i <= $review; $i++)
                                                    <i class="ti-star filled text-warning"></i>
                                                @endfor
                                                @if (is_float($review))
                                                    <i class="ti-star text-warning"></i>
                                                @endif
                                            </div>
                                        @endif
                                        <!-- Property Type Label -->
                                        <span
                                            class="property-type position-absolute top-0 start-0 p-2 bg-primary text-white rounded">
                                            @if ($property->looking_for == 'for_rent')
                                                {{ __('For Rent') }}
                                            @elseif ($property->looking_for == 'for_sell')
                                                {{ __('For Sell') }}
                                            @elseif ($property->looking_for == 'for_pg')
                                                {{ __('For PG') }}
                                            @else
                                                {{ __('Property') }}
                                            @endif
                                        </span>
                                    </div>
                                    <!-- Right Side: Property Details -->
                                    <div class="property-details px-4 flex-grow-1" style="width: 50%;">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <p class="property-price mt-4" style="color: #3936f8; font-weight: bold;">
                                                {{ showAmount($property->price) }}</p>
                                            <!-- Share Button -->
                                            <svg class="mt-2" xmlns="http://www.w3.org/2000/svg" x="0px" y="0px"
                                                width="24" height="22" viewBox="0 0 30 30" style="fill:#474646;"
                                                onclick="toggleShareOptions(event, '{{ $property->id }}')">
                                                <path
                                                    d="M 23 3 C 20.791 3 19 4.791 19 7 C 19 7.2869826 19.034351 7.5660754 19.091797 7.8359375L 10 12.380859 C 9.2667379 11.541629 8.2018825 11 7 11 C 4.791 11 3 12.791 3 15 C 3 17.209 4.791 19 7 19 C 8.2018825 19 9.2667379 18.458371 10 17.619141 L 19.091797 22.164062 C 19.034351 22.433925 19 22.713017 19 23 C 19 25.209 20.791 27 23 27 C 25.209 27 27 25.209 27 23 C 27 20.791 25.209 19 23 19 C 21.798117 19 20.733262 19.541629 20 20.380859 L 10.908203 15.835938 C 10.965649 15.566075 11 15.286983 11 15 C 11 14.713017 10.965649 14.433925 10.908203 14.164062 L 20 9.6191406 C 20.733262 10.458371 21.798117 11 23 11 C 25.209 11 27 9.209 27 7 C 27 4.791 25.209 3 23 3 z">
                                                </path>
                                            </svg>
                                            <!-- Share Options -->
                                            <div class="share-options" id="shareOptions-{{ $property->id }}"
                                                style="display: none;">
                                                <a href="#" onclick="share('whatsapp', '{{ $propertyUrl }}')"><i
                                                        class="fa-brands fa-whatsapp"></i>&nbsp;&nbsp; WhatsApp &nbsp;</a>
                                                <a href="#" onclick="copyLink('{{ $propertyUrl }}')"><i
                                                        class="ti-link"></i>&nbsp;&nbsp; Copy Link &nbsp;</a>
                                                <a href="#" onclick="share('instagram', '{{ $propertyUrl }}')"><i
                                                        class="ti-instagram"></i>&nbsp;&nbsp; Instagram &nbsp;</a>
                                                <a href="#" onclick="share('facebook', '{{ $propertyUrl }}')"><i
                                                        class="ti-facebook"></i>&nbsp;&nbsp; Facebook &nbsp;</a>
                                                <a href="#" onclick="share('twitter', '{{ $propertyUrl }}')"><i
                                                        class="fa-brands fa-x"></i>&nbsp;&nbsp; Twitter &nbsp;</a>
                                                <a href="#" onclick="share('linkedin', '{{ $propertyUrl }}')"><i
                                                        class="ti-linkedin"></i>&nbsp;&nbsp; Linkedin &nbsp;</a>
                                            </div>
                                        </div>
                                        <div class="d-flex align-items-center justify-content-between mb-2">
                                            <div>
                                                <h5 class="property-title mt-2">{{ $property->name ?? '' }}</h5>
                                                <p class="property-location text-muted">
                                                    <i class="ti-location-pin"></i> {{ $property->locality ?? '' }},
                                                    {{ $property->location->name ?? '' }}
                                                </p>
                                            </div>
                                            <div class="ms-auto text-end">
                                                <span>{{ $property->user->name }}</span><br>
                                                <small class="text-muted">{{ $property->user->user_type }}</small><br>
                                                <small class="text-muted">Phone : +91{{ $property->user->phone }}</small>
                                            </div>
                                        </div>
                                        <!-- Features -->
                                        <div class="property-features d-flex justify-content-between text-muted mt-3"
                                            style="font-size: small">
                                            <p><i class="ti-home"></i> BHK <br>&nbsp; {{ $property->no_of_bhk }}</p>
                                            @if ($property->construction_status == 'under-construction')
                                                <p><i class="fa-solid fa-calendar-alt"></i> Possession Date
                                                    <br> &nbsp;{{ $property->possession_date }}
                                                </p>
                                            @elseif ($property->construction_status == 'ready-to-move')
                                                <p><i class="fa-solid fa-clock"></i> Age Of Property <br> &nbsp;
                                                    {{ $property->property_age }} Years
                                                </p>
                                            @endif
                                            <p><i class="fa-solid fa-building"></i> Construction Status <br> &nbsp;
                                                {{ ucwords(str_replace('-', ' ', $property->construction_status)) }}
                                            </p>
                                            <p><i class="ti-ruler-pencil"></i> Carpet Area <br> &nbsp;
                                                {{ $property->carpet_area }}
                                                Sqft
                                            </p>
                                            <p><i class="fa-solid me-1">₹</i>Price Per Sqft <br> &nbsp;
                                                {{ $property->price_per_sqft }}
                                                Sqft</p>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        </div>
                    @endforeach
                @endif
            </div>
        </div>
    </div>
@endsection
@push('js')
    <script>
        'use strict';
 $(document).on('click', '#wishList', function() {
            let $this = $(this);
            let propertyId = $this.data('property');
            let userId = $this.data('user');

            if (!userId) {
                window.location.href = mainurl + '/login-register';
                return;
            }

            console.log("Wishlist Clicked!");

            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                method: "POST",
                url: mainurl + '/property/wishlist',
                data: {
                    property_id: propertyId,
                    user_id: userId
                },
                success: function(data) {
                    if (data.success) {
                        $this.removeClass().addClass('like-bitt add-to-favorite');
                        toastr.success(data.success);
                    } else {
                        $this.removeClass().addClass('add-to-favorite');
                        toastr.error(data.error);
                    }
                    setTimeout(() => {
                        location.reload();
                    }, 1000);
                }
            });
        });
        function myFunction() {
            var copyText = document.getElementById("cronjobURL");
            copyText.select();
            copyText.setSelectionRange(0, 99999);
            document.execCommand("copy");
            $.notify("Referral url copied", "info");
        }
    </script>
    <script>
        function toggleShareOptions(event, propertyId) {
            event.preventDefault();
            var shareOptions = document.getElementById('shareOptions-' + propertyId);
            shareOptions.style.display = (shareOptions.style.display === 'none' || shareOptions.style.display === '') ?
                'block' : 'none';
            setTimeout(function() {
                shareOptions.style.display = 'none';
            }, 2000);
        }

        function share(platform, url) {
            let text = "Check this out!";
            let shareUrl = "";
            switch (platform) {
                case 'facebook':
                    shareUrl = `https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(url)}`;
                    break;
                case 'twitter':
                    shareUrl =
                        `https://twitter.com/intent/tweet?text=${encodeURIComponent(text)}&url=${encodeURIComponent(url)}`;
                    break;
                case 'instagram':
                    shareUrl = `https://www.instagram.com/?url=${encodeURIComponent(url)}`;
                    break;
                case 'linkedin':
                    shareUrl = `https://www.linkedin.com/sharing/share-offsite/?url=${encodeURIComponent(url)}`;
                    break;
                case 'whatsapp':
                    shareUrl = `https://wa.me/?text=${encodeURIComponent(text)}%20${encodeURIComponent(url)}`;
                    break;
                default:
                    console.log("Unsupported platform");
                    return;
            }
            if (shareUrl) {
                window.open(shareUrl, '_blank', 'noopener,noreferrer');
            }
        }

        function copyLink(url) {
            navigator.clipboard.writeText(url).then(function() {
                alert('Link copied to clipboard: ' + url);
            }, function(err) {
                console.error('Could not copy text: ', err);
            });
        }
    </script>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            document.querySelectorAll(".clickable-box").forEach(function(box) {
                box.addEventListener("click", function() {
                    let target = this.getAttribute("data-target");
                    document.querySelectorAll(".data-content").forEach(content => content.style
                        .display = "none");
                    document.getElementById(target).style.display = "block";
                });
            });
        });
    </script>
@endpush
