@extends('layouts.user')
@push('css')
    <style>
        body {
            font-size: 15px;
        }

        .property-img1 img {
            width: 400px;
            height: 225px;
            object-fit: cover;
        }

        @media (min-width: 576px) {
            .img {
                width: auto;
                height: auto;
            }
        }

        #recent-search-list li {
            display: flex;
            justify-content: space-between;
            align-items: center;
            /* no border */
        }

        #recent-search-list li span {
            flex: 1 1 auto;
            min-width: 0;
            /* important for truncation */
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            margin-right: 10px;
        }

        #recent-search-list li a.redo-search-icon {
            flex: 0 0 auto;
            padding: 4px 8px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        @media (max-width: 576px) {
            #recent-search-list li span {
                font-size: 14px;
                white-space: nowrap;
            }

            #recent-search-list li a.redo-search-icon {
                padding: 2px 6px;
                font-size: 16px;
            }
        }

        .dashboard-stat-content {
            position: absolute;
            left: 10px;
            top: 50%;
            transform: translateY(-50%);
        }

        .filter-btn-group input[type="radio"]:checked+* {
            /* Add your checked state styling */
            background-color: #007bff;
            color: white;
        }

        /* Or for Bootstrap */
        .filter-btn-group .btn-secondary:active,
        .filter-btn-group .btn-secondary.active {
            background-color: #6c757d;
            border-color: #6c757d;
        }
    </style>
@endpush
@section('title')
    <!-- ============================ Page Title Start================================== -->
    <div class="page-title m-0">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12">
                    <h2 class="ipt-title">@lang('Welcome')!</h2>
                    <span class="ipn-subtitle">@lang('Welcome To Your Account')</span>
                </div>
            </div>
        </div>
    </div>
    <!-- ============================ Page Title End ================================== -->
@endsection
@section('content')
    <!-- ============================ User Dashboard ================================== -->
    @if (session('message'))
        <div class="alert alert-success">
            {{ session('message') }}
        </div>
    @endif

    @if (auth()->check() && !auth()->user()->hasVerifiedEmail())
        <div class="modal fade" id="verifyEmailModal" tabindex="-1" role="dialog" aria-labelledby="verifyEmailLabel"
            aria-hidden="true" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content border shadow-lg rounded">
                    <div class="modal-header bg-success text-dark">
                        <h5 class="modal-title fw-bold" id="verifyEmailLabel">Email Verification Required</h5>
                    </div>
                    <div class="modal-body">
                        <p id="verificationPrompt" class="mb-3">
                            Your email address is not verified. Please click below button to verify your email.
                        </p>

                        <div id="verificationMessage"></div>

                        {{-- ✅ SEND button: shown by default --}}
                        <form id="sendVerificationForm">
                            @csrf
                            <button type="submit" class="btn btn-primary btn-sm" id="sendBtn">
                                Send Verification Email
                            </button>
                        </form>
                    </div>
                    <div class="modal-footer">
                        <button id="remindMeBtn" type="button" class="btn btn-outline-secondary btn-sm"
                            data-dismiss="modal">
                            Remind Me Later
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <script>
            document.addEventListener("DOMContentLoaded", function() {
                setTimeout(() => {
                    $('#verifyEmailModal').modal('show');
                }, 300);

                const form = document.getElementById('sendVerificationForm');
                const messageDiv = document.getElementById('verificationMessage');
                const remindBtn = document.getElementById('remindMeBtn');
                const promptText = document.getElementById('verificationPrompt');
                const sendBtn = document.getElementById('sendBtn');

                remindBtn.addEventListener('click', function() {
                    $('#verifyEmailModal').modal('hide');
                });

                form.addEventListener('submit', function(e) {
                    e.preventDefault();

                    messageDiv.innerHTML = `
            <div class="alert alert-success p-2 mt-3" role="alert">
                ✅ Sending verification email...
            </div>`;

                    fetch("{{ route('verification.send') }}", {
                            method: "POST",
                            headers: {
                                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                                'Accept': 'application/json'
                            },
                        })
                        .then(response => {
                            if (response.ok) {
                                promptText.style.display = 'none';

                                messageDiv.innerHTML = `
                    <div class="alert alert-success p-2 mt-3" role="alert">
                        Please check your inbox for the verification link.
                    </div>`;

                                // ✅ Update button text
                                sendBtn.textContent = 'Resend Verification Email';

                                remindBtn.style.display = 'inline-block';
                            } else {
                                return response.json().then(data => {
                                    throw new Error(data.message || "Something went wrong.");
                                });
                            }
                        })
                        .catch(error => {
                            messageDiv.innerHTML = `
                <div class="alert alert-danger p-2 mt-3" role="alert">
                    ⚠️ ${error.message}
                </div>`;
                        });
                });
            });
        </script>
    @endif

    <div class="dashboard-wraper">
        <div class="mb-3">
            <p>@lang('Your Current Package'): <span
                    class="pc-title theme-cl">{{ auth()->user()->plan != null ? auth()->user()->plan->title . '(' . Carbon\Carbon::parse(auth()->user()->plan_end_date)->format('d-m-Y') . ')' : 'N/A' }}</span>
            </p>
            @if (auth()->user()->plan == null)
                <!--<p class="text-danger">@lang('To be an agent, you should under a subscription package.')</p>-->
            @endif
        </div>
        <h6>My Activity</h6>
        <div class="row g-3">
            <div class="col-lg-3 col-md-6 col-sm-12">
                <div class="dashboard-stat mb-0 widget-1 text-center pt-2 clickable-box" data-target="contacted-data">
                    <div class="dashboard-stat-content">
                        <i class="ti-user"></i>
                        <span>@lang('Contacted Properties') : </span>
                        {{ $contactsTotalCount ?? 0 }}
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12">
                <div class="dashboard-stat mb-0 widget-2 text-center pt-2 clickable-box" data-target="seen-data">
                    <div class="dashboard-stat-content">
                        <i class="ti-eye"></i>
                        <span>@lang('Seen Properties') : </span>
                        {{ $seenPropertyTotalCount ?? 0 }}
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12">
                <div class="dashboard-stat mb-0 widget-3 text-center pt-2 clickable-box" data-target="saved-data">
                    <div class="dashboard-stat-content">
                        <i class="lni-heart-filled"></i>
                        <span>@lang('Wishlisted Properties') : </span>
                        {{ $savedPropertyTotalCount ?? 0 }}
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12">
                <div class="dashboard-stat mb-0 widget-4 text-center pt-2 clickable-box" data-target="recent-searches-data">
                    <div class="dashboard-stat-content">
                        <i class="ti-search"></i>
                        <span>Recent Searches</span>
                    </div>
                </div>
            </div>
        </div>
        <div class="mb-3 filter-btn-group">
            <label class="btn btn-secondary btn-sm rounded border-secondary {{ empty($currentFilter) ? 'active' : '' }}">
                <input name="looking_for" type="radio" value=""
                    {{ empty($currentFilter) ? 'checked' : '' }}>@lang('All')
            </label>
            <label
                class="btn btn-secondary btn-sm rounded border-secondary {{ $currentFilter === 'for_rent' ? 'active' : '' }}">
                <input name="looking_for" type="radio" value="for_rent"
                    {{ $currentFilter === 'for_rent' ? 'checked' : '' }}>@lang('For Rent')
            </label>
            <label
                class="btn btn-secondary btn-sm rounded border-secondary {{ $currentFilter === 'for_sell' ? 'active' : '' }}">
                <input name="looking_for" type="radio" value="for_sell"
                    {{ $currentFilter === 'for_sell' ? 'checked' : '' }}>@lang('For Sell')
            </label>
            <label
                class="btn btn-secondary btn-sm rounded border-secondary {{ $currentFilter === 'for_pg' ? 'active' : '' }}">
                <input name="looking_for" type="radio" value="for_pg"
                    {{ $currentFilter === 'for_pg' ? 'checked' : '' }}>@lang('For PG')
            </label>
        </div>
        <!-- Data Display Section -->
        <div class="data-container">
            <div class="data-container">
                <div id="contacted-data" class="data-content" style="display: block;">
                    @include('user.partials.contacted_properties', [
                        'contacts' => $contacts,
                        'currentFilter' => $currentFilter,
                    ])
                </div>
                <div id="seen-data" class="data-content" style="display: none;">
                    @include('user.partials.seen_properties', [
                        'seenProperties' => $seenProperties,
                        'currentFilter' => $currentFilter,
                    ])
                </div>
                <div id="saved-data" class="data-content" style="display: none;">
                    @include('user.partials.saved_properties', [
                        'savedProperty' => $savedProperty,
                        'currentFilter' => $currentFilter,
                    ])
                </div>
            </div>
            <div id="recent-searches-data" class="data-content  mt-3 " style="display: none;">
                <h4>@lang('Recent Searches')</h4>
                <button id="clear-history" class="btn btn-dark btn-sm mb-2">Clear History</button>
                <div id="recent-searches">
                    <ul id="recent-search-list"></ul>
                </div>
            </div>
        </div>
    </div>
    <div class="dashboard-wraper">
        <div class="row">
            <div class="dashboard--content-item">
                <div class="row gy-4">
                    <div class="col-md-12">
                        <div class="dashboard--content-item">
                            <h5 class="dashboard-title">@lang('Referral URL')</h5>
                            <div class="dashboard-refer">
                                <div class="input-group input--group">
                                    <input type="text" class="form-control form--control" readonly
                                        value="{{ url('/') . '?reff=' . $user->affilate_code }}" id="cronjobURL">
                                    <button class="input-group-text px-3 btn--primary border-0" type="button"
                                        id="copyBoard" onclick="myFunction()">
                                        <i class="far fa-copy"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="dashboard--content-item">
                <div class="table-responsive table--mobile-lg">
                    <table class="table bg--body">
                        <thead>
                            <tr>
                                <th>@lang('No')</th>
                                <th>@lang('Type')</th>
                                <th>@lang('Txnid')</th>
                                <th>@lang('Amount')</th>
                                <th>@lang('Date')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if (count($transactions) == 0)
                                <tr>
                                    <td colspan="12">
                                        <p class="text-center m-0 py-2">{{ __('No Data Found') }}</p>
                                    </td>
                                </tr>
                            @else
                                @foreach ($transactions as $key => $property)
                                    <tr>
                                        <td data-label="@lang('No')">
                                            <div>
                                                <span class="">{{ $loop->iteration }}</span>
                                            </div>
                                        </td>
                                        <td data-label="@lang('Type')">
                                            <div>
                                                {{ strtoupper($property->type) }}
                                            </div>
                                        </td>
                                        <td data-label="@lang('Txnid')">
                                            <div>
                                                {{ $property->txnid }}
                                            </div>
                                        </td>
                                        <td data-label="@lang('Amount')">
                                            <div>
                                                <p class="text-{{ $property->profit == 'plus' ? 'success' : 'danger' }}">
                                                    {{ $property->amount }}</p>
                                            </div>
                                        </td>
                                        <td data-label="@lang('Date')">
                                            <div>
                                                {{ date('d M Y', strtotime($property->created_at)) }}
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('js')
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        'use strict';
        $(document).on('click', '#wishList', function() {
            let $this = $(this);
            let propertyId = $this.data('property');
            let userId = $this.data('user');

            if (!userId) {
                window.location.href = mainurl + '/login-register';
                return;
            }

            console.log("Wishlist Clicked!");

            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                method: "POST",
                url: mainurl + '/property/wishlist',
                data: {
                    property_id: propertyId,
                    user_id: userId
                },
                success: function(data) {
                    if (data.success) {
                        $this.removeClass().addClass('like-bitt add-to-favorite');
                        toastr.success(data.success);
                    } else {
                        $this.removeClass().addClass('add-to-favorite');
                        toastr.error(data.error);
                    }
                    setTimeout(() => {
                        location.reload();
                    }, 1000);
                }
            });
        });

        function myFunction() {
            var copyText = document.getElementById("cronjobURL");
            copyText.select();
            copyText.setSelectionRange(0, 99999);
            document.execCommand("copy");
            $.notify("Referral url copied", "info");
        }

        function toggleShareOptions(event, propertyId) {
            event.preventDefault();
            var shareOptions = document.getElementById('shareOptions-' + propertyId);
            shareOptions.style.display = (shareOptions.style.display === 'none' || shareOptions.style.display === '') ?
                'block' : 'none';
            setTimeout(function() {
                shareOptions.style.display = 'none';
            }, 2000);
        }

        function share(platform, url) {
            let text = "Check this out!";
            let shareUrl = "";
            switch (platform) {
                case 'facebook':
                    shareUrl = `https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(url)}`;
                    break;
                case 'twitter':
                    shareUrl =
                        `https://twitter.com/intent/tweet?text=${encodeURIComponent(text)}&url=${encodeURIComponent(url)}`;
                    break;
                case 'instagram':
                    shareUrl = `https://www.instagram.com/?url=${encodeURIComponent(url)}`;
                    break;
                case 'linkedin':
                    shareUrl = `https://www.linkedin.com/sharing/share-offsite/?url=${encodeURIComponent(url)}`;
                    break;
                case 'whatsapp':
                    shareUrl = `https://wa.me/?text=${encodeURIComponent(text)}%20${encodeURIComponent(url)}`;
                    break;
                default:
                    console.log("Unsupported platform");
                    return;
            }
            if (shareUrl) {
                window.open(shareUrl, '_blank', 'noopener,noreferrer');
            }
        }

        function copyLink(url) {
            navigator.clipboard.writeText(url).then(function() {
                alert('Link copied to clipboard: ' + url);
            }, function(err) {
                console.error('Could not copy text: ', err);
            });
        }

        document.addEventListener("DOMContentLoaded", function() {
            document.querySelectorAll(".clickable-box").forEach(function(box) {
                box.addEventListener("click", function() {
                    let target = this.getAttribute("data-target");
                    document.querySelectorAll(".data-content").forEach(content => content.style
                        .display = "none");
                    document.getElementById(target).style.display = "block";
                });
            });
        });

        $(document).ready(function() {
            let recentSearches = JSON.parse(localStorage.getItem("recentSearches")) || [];
            console.log("Loaded recent searches:", recentSearches);

            let searchList = $("#recent-search-list");
            searchList.html("");

            if (recentSearches.length === 0) {
                searchList.append("<li>No recent searches found.</li>");
                $("#recent-searches-data").hide();
            } else {
                recentSearches.forEach((search, index) => {
                    let searchText = [];

                    // 1. Name
                    if (search.name) searchText.push(`<strong>${search.name}</strong>`);

                    // 2. City (get text from select dropdown if possible)
                    let cityName = '';
                    if (search.location_id) {
                        let cityOption = $('select[name="location_id"] option[value="' + search
                            .location_id + '"]');
                        if (cityOption.length) {
                            cityName = cityOption.text().trim();
                            searchText.push(`City: ${cityName}`);
                        }
                    }

                    // 3. Category
                    if (search.category_id) {
                        let catOption = $('select[name="category_id"] option[value="' + search.category_id +
                            '"]');
                        if (catOption.length) {
                            searchText.push(`Category: ${catOption.text().trim()}`);
                        }
                    }

                    // 4. BHK
                    if (search.no_of_bhk) searchText.push(`BHK: ${search.no_of_bhk}`);

                    // 5. Price
                    if (search.minPrice && search.maxPrice) {
                        searchText.push(
                            `Price: ₹${Number(search.minPrice).toLocaleString()} - ₹${Number(search.maxPrice).toLocaleString()}`
                        );
                    }

                    // 6. Sale Type
                    if (search.sale_type) searchText.push(`Sale Type: ${search.sale_type}`);

                    // 7. Construction Status
                    if (search.construction_status) searchText.push(
                        `Status: ${search.construction_status}`);

                    // Build URL
                    let searchParams = new URLSearchParams();
                    if (search.name) searchParams.append('name', search.name);
                    if (search.location_id) searchParams.append('location_id', search.location_id);
                    if (search.category_id) searchParams.append('category_id', search.category_id);
                    if (search.no_of_bhk) searchParams.append('no_of_bhk', search.no_of_bhk);
                    if (search.minPrice) searchParams.append('minPrice', search.minPrice);
                    if (search.maxPrice) searchParams.append('maxPrice', search.maxPrice);
                    if (search.sale_type) searchParams.append('sale_type', search.sale_type);
                    if (search.construction_status) searchParams.append('construction_status', search
                        .construction_status);
                    if (search.type) searchParams.append('type', search.type);
                    if (search.autoSubmit) searchParams.append('autoSubmit', search.autoSubmit);

                    // Append to UI
                    if (searchText.length > 0) {
                        searchList.append(`
                            <li class="d-flex justify-content-between align-items-center my-2">
                                <span>${searchText.join(" | ")}</span>
                                <a href="{{ url('listing') }}?${searchParams.toString()}" class="redo-search-icon" title="Search again">
                                    <i class="ti-search"></i>
                                </a>
                            </li>
                        `);
                    }
                });

                $("#recent-searches-data").show();
            }

            $("#clear-history").click(function() {
                localStorage.removeItem("recentSearches");
                searchList.html("<li>No recent searches found.</li>");
                $("#recent-searches-data").hide();
                console.log("Search history cleared!");
            });
        });

        document.addEventListener("DOMContentLoaded", function() {
            const lastShown = localStorage.getItem('verify_email_popup_last_shown');
            const now = Date.now();
            const oneHour = 60 * 60 * 1000;

            if (!lastShown || (now - lastShown) > oneHour) {
                $('#verifyEmailModal').modal('show');
                localStorage.setItem('verify_email_popup_last_shown', now);
            }
        });
    </script>
    <script>
        $(document).ready(function() {
            let currentActiveTab = 'contacted-data'; // Default tab

            // Handle tab switching
            $('.clickable-box').on('click', function() {
                // Hide all content divs
                $('.data-content').hide();

                // Get the target tab
                currentActiveTab = $(this).data('target');

                // Show the selected tab
                $('#' + currentActiveTab).show();
            });

            // Single handler for filter changes
            $('input[name="looking_for"]').on('change', function() {
                var lookingFor = $(this).val();

                // Send AJAX request with both filter and current tab
                $.ajax({
                    url: '{{ route('user.dashboard.filter') }}',
                    type: 'GET',
                    data: {
                        looking_for: lookingFor,
                        active_tab: currentActiveTab
                    },
                    beforeSend: function() {
                        $('#' + currentActiveTab).html('<p>Loading...</p>');
                    },
                    success: function(response) {
                        // Update the content
                        $('#' + currentActiveTab).html(response.html);

                        // Update all radio buttons in the filter group
                        $('.filter-btn-group input[name="looking_for"]').prop('checked', false);
                        $(`.filter-btn-group input[name="looking_for"][value="${response.current_filter}"]`)
                            .prop('checked', true)
                            .closest('label').addClass('active').siblings().removeClass(
                                'active');
                    },
                    error: function(xhr) {
                        $('#' + currentActiveTab).html('<p>Error loading data</p>');
                    }
                });
            });
        });
        
    </script>
@endpush
