@extends('layouts.front')

@push('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/css/intlTelInput.css" />
    <style>
        .iti {
            width: 100%;
        }

        .iti__country-list {
            position: absolute;
            z-index: 2;
            width: 273px;
        }

        .iti__dropdown {
            width: 100% !important;
            box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.1);
            z-index: 1050;
        }
    </style>
@endpush

@section('content')
    <section class="gray"style="background: url('https://images.unsplash.com/photo-1605146769289-440113cc3d00?q=80&w=1470&auto=format&fit=crop&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D') no-repeat center center;
    background-size: cover;">
        <div class="container my-5">
            <div class="row justify-content-center">
                <div class="col-md-5">
                    <div class="card p-4">
                        <div class="text-white text-center mb-2 mt-2">
                            <h3>@lang('Login/Register')</h3>
                        </div>
                        <div class="card-body">
                            <form id="" action="{{ route('user.login_register') }}" method="POST">
                                @includeIf('partials.user.form-both')
                                @csrf
                                <div class="form-group mb-5">
                                    <label for="phone" class="form-label">@lang('Please Enter Your Phone Number')</label>
                                    <input type="tel" name="phone" id="phone" class="form-control rounded"
                                        placeholder="Enter Number" required aria-label="Phone Number">
                                    @if ($errors->has('phone'))
                                        <span class="invalid-feedback d-block" role="alert">
                                            <strong>{{ $errors->first('phone') }}</strong>
                                        </span>
                                    @endif
                                </div>
                                <div class="form-group text-center">
                                    <button type="submit" class="btn rounded theme-bg w-100">
                                        @lang('Continue')
                                    </button>
                                    <!--<p class="mb-0">-->
                                    <!--      @lang('Have You Already An account')?-->
                                    <!--      <a href="{{ route('login_register') }}" class="btn rounded theme-bg w-100">@lang('Continue')</a>-->
                                    <!--  </p>-->
                                </div>
                                <div class="form-group text-center mt-4 mb-0">
                                    <p class="mb-0">
                                        @lang('Have You Already An account')?
                                        <a href="{{ route('user.otp') }}"
                                            class="ft-medium text-success">@lang('Login')</a>
                                    </p>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    @includeIf('partials.front.cta')
@endsection

@push('js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/intlTelInput.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const phoneInput = document.getElementById('phone'); // Get phone input element
            if (phoneInput) {
                try {
                    const iti = intlTelInput(phoneInput, {
                        initialCountry: "in",
                        separateDialCode: true,
                        preferredCountries: ["in", "us", "gb"],
                        utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/utils.js",
                    });
                } catch (error) {
                    console.error('Error initializing intlTelInput:', error);
                }
            }
        });
    </script>
@endpush
