<h4>@lang('Wishlisted Properties')</h4>
@if (empty($savedProperty))
    No data Available
@else
    @foreach ($savedProperty as $contact)
        @php
            $property = $contact->property;
            $routes = [
                'for_pg' => 'pg.details',
                'for_rent' => 'rent.details',
                'for_sell' => 'buy.details',
                'plot' => 'plot.details',
                'commercial' => 'commercial.details',
            ];
            $propertyUrl = isset($routes[$property->looking_for])
                ? route($routes[$property->looking_for], $property->slug)
                : '#';
            $features = [];
            if ($property->no_of_bhk) {
                $features[] = '<p><i class="ti-home"></i> BHK <br>&nbsp;' . $property->no_of_bhk . '</p>';
            }
            if ($property->construction_status == 'under-construction' && $property->possession_date) {
                $features[] =
                    '<p><i class="fa-solid fa-calendar-alt"></i> Possession Date <br>&nbsp;' .
                    $property->possession_date .
                    '</p>';
            } elseif ($property->construction_status == 'ready-to-move' && $property->property_age) {
                $features[] =
                    '<p><i class="fa-solid fa-clock"></i> Age Of Property <br>&nbsp;' .
                    $property->property_age .
                    ' Years</p>';
            }
            if ($property->construction_status) {
                $features[] =
                    '<p><i class="fa-solid fa-building"></i> Construction Status <br>&nbsp;' .
                    ucwords(str_replace('-', ' ', $property->construction_status)) .
                    '</p>';
            }
            if ($property->carpet_area) {
                $features[] =
                    '<p><i class="ti-ruler-pencil"></i> Carpet Area <br>&nbsp;' . $property->carpet_area . ' Sqft</p>';
            }
            if ($property->price_per_sqft) {
                $features[] =
                    '<p><i class="fa-solid me-1">₹</i> Price Per Sqft <br>&nbsp;' .
                    $property->price_per_sqft .
                    ' Sqft</p>';
            }
            if ($property->plot_area) {
                $features[] =
                    '<p><i class="bi bi-rulers"></i> Plot Area <br>&nbsp;<b>' .
                    $property->plot_area .
                    ' ' .
                    $property->area_unit .
                    '</b></p>';
            }
            if ($property->plot_length && $property->plot_width) {
                $features[] =
                    '<p><i class="bi bi-clock-history"></i> Plot Dimensions <br>&nbsp;<b>' .
                    ucfirst($property->plot_length . ' X ' . $property->plot_width) .
                    '</b></p>';
            }
            if ($property->floors_allowed) {
                $features[] =
                    '<p><i class="bi bi-building"></i> Floors Allowed <br>&nbsp;<b>' .
                    $property->floors_allowed .
                    ' ' .
                    ($property->floors_allowed == 1 ? 'Floor' : 'Floors') .
                    '</b></p>';
            }
            if ($property->open_sides) {
                $features[] =
                    '<p><i class="bi bi-box-arrow-in-left"></i> No. Of Open Sides <br>&nbsp;<b>' .
                    $property->open_sides .
                    ' ' .
                    ($property->open_sides == 1 ? 'Side' : 'Sides') .
                    '</b></p>';
            }
            $features = array_slice($features, 0, 3);
        @endphp
        <div class="col-lg-12 col-md-12">
            <a href="{{ $propertyUrl }}" target="_blank">
                <div
                    class="property-card d-flex flex-wrap flex-md-nowrap shadow-lg rounded-3 overflow-hidden position-relative pt-2">
                    <div class="property-img1 position-relative ">
                        <img src="{{ asset('assets/images/' . $property->photo) }}" class="img-fluid img"
                            alt="Property Image">
                        <!-- Wishlist Icon -->
                        <div class="wishlist-icon position-absolute top-0 end-0 p-2">
                            <a href="JavaScript:Void(0);" id="wishList"
                                class="{{ $property->checkFavourite(auth()->id(), $property->id) ? 'like-bitt' : '' }} add-to-favorite"
                                data-property="{{ $property->id }}" data-user="{{ auth()->id() }}"
                                data-bs-toggle="tooltip" data-original-title="Add To Favorites">
                                <i class="lni-heart-filled"></i>
                            </a>
                        </div>
                        <!-- Rating -->
                        @if ($property->reviews->count() > 0)
                            <div
                                class="listing-rating position-absolute bottom-0 start-0 p-2 bg-dark text-white rounded">
                                @php
                                    $review = $property->reviews->sum('rate') / $property->reviews->count();
                                @endphp
                                @for ($i = 1; $i <= $review; $i++)
                                    <i class="ti-star filled text-warning"></i>
                                @endfor
                                @if (is_float($review))
                                    <i class="ti-star text-warning"></i>
                                @endif
                            </div>
                        @endif
                        <!-- Property Type Label -->
                        <span class="property-type position-absolute top-0 start-0 p-2 bg-primary text-white rounded">
                            @if ($property->looking_for == 'for_rent')
                                {{ __('For Rent') }}
                            @elseif ($property->looking_for == 'for_sell')
                                {{ __('For Sell') }}
                            @elseif ($property->looking_for == 'for_pg')
                                {{ __('For PG') }}
                            @else
                                {{ __('Property') }}
                            @endif
                        </span>
                    </div>
                    <!-- Right Side: Property Details -->
                    <div class="property-details px-4 flex-grow-1" style="width: 50%;">
                        <div class="d-flex justify-content-between align-items-center">
                            <p class="property-price mt-4" style="color: #3936f8; font-weight: bold;">
                                {{ showAmount($property->price) }}</p>
                            <!-- Share Button -->
                            <svg class="mt-2" xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="24"
                                height="22" viewBox="0 0 30 30" style="fill:#474646;"
                                onclick="toggleShareOptions(event, '{{ $property->id }}')">
                                <path
                                    d="M 23 3 C 20.791 3 19 4.791 19 7 C 19 7.2869826 19.034351 7.5660754 19.091797 7.8359375L 10 12.380859 C 9.2667379 11.541629 8.2018825 11 7 11 C 4.791 11 3 12.791 3 15 C 3 17.209 4.791 19 7 19 C 8.2018825 19 9.2667379 18.458371 10 17.619141 L 19.091797 22.164062 C 19.034351 22.433925 19 22.713017 19 23 C 19 25.209 20.791 27 23 27 C 25.209 27 27 25.209 27 23 C 27 20.791 25.209 19 23 19 C 21.798117 19 20.733262 19.541629 20 20.380859 L 10.908203 15.835938 C 10.965649 15.566075 11 15.286983 11 15 C 11 14.713017 10.965649 14.433925 10.908203 14.164062 L 20 9.6191406 C 20.733262 10.458371 21.798117 11 23 11 C 25.209 11 27 9.209 27 7 C 27 4.791 25.209 3 23 3 z">
                                </path>
                            </svg>
                            <!-- Share Options -->
                            <div class="share-options" id="shareOptions-{{ $property->id }}" style="display: none;">
                                <a href="{{ $propertyUrl }}" onclick="share('whatsapp', '#')"><i
                                        class="fa-brands fa-whatsapp"></i>&nbsp;&nbsp; WhatsApp &nbsp;</a>
                                <a href="{{ $propertyUrl }}" onclick="copyLink('#')"><i
                                        class="ti-link"></i>&nbsp;&nbsp; Copy Link &nbsp;</a>
                                <a href="{{ $propertyUrl }}" onclick="share('instagram', '#')"><i
                                        class="ti-instagram"></i>&nbsp;&nbsp; Instagram &nbsp;</a>
                                <a href="{{ $propertyUrl }}" onclick="share('facebook', '#')"><i
                                        class="ti-facebook"></i>&nbsp;&nbsp; Facebook &nbsp;</a>
                                <a href="{{ $propertyUrl }}" onclick="share('twitter', '#')"><i
                                        class="fa-brands fa-x"></i>&nbsp;&nbsp; Twitter &nbsp;</a>
                                <a href="{{ $propertyUrl }}" onclick="share('linkedin', '#')"><i
                                        class="ti-linkedin"></i>&nbsp;&nbsp; Linkedin &nbsp;</a>
                            </div>
                        </div>
                        <div class="d-flex align-items-center justify-content-between mb-2">
                            <div>
                                <h5 class="property-title mt-2">{{ $property->name }}</h5>
                                <p class="property-location text-muted">
                                    <i class="ti-location-pin"></i> {{ $property->locality }},
                                    {{ $property->location->name }}
                                </p>
                            </div>
                            <div class="ms-auto text-end">
                                <span>{{ $property->user->name }}</span><br>
                                <span class="text-muted">{{ $property->user->user_type }}</span><br>
                                <span class="text-muted"> +91{{ $property->user->phone }}</span>
                            </div>
                        </div>
                        <!-- Features -->
                        @if (count($features) > 0)
                            <div class="property-features d-flex flex-wrap justify-content-between text-muted mt-3"
                                style="font-size: 11px">
                                @foreach ($features as $feature)
                                    {!! $feature !!}
                                @endforeach
                            </div>
                        @endif
                    </div>
                </div>
            </a>
        </div>
    @endforeach
@endif