@extends('layouts.user')
@push('css')
    <style>
        #recent-search-list {
            border: 1px solid #ddd;
            padding: 15px;
            background: #f9f9f9;
            color: #474646;
            font-size: 13px;
        }
        #recent-searches-data {
            display: block !important;
        }
    </style>
@endpush
@section('content')
    <div class="dashboard-wraper">
        <h6>My Activity</h6>
        <div class="data-container mt-4">
            <div id="recent-searches-data" class="data-content">
                <h4>@lang('Recent Searches')</h4>
                <button id="clear-history" class="btn btn-dark btn-sm mb-2">Clear History</button>
                <div id="recent-searches">
                    <ul id="recent-search-list"></ul>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('js')
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function() {
    let recentSearches = JSON.parse(localStorage.getItem("recentSearches")) || [];
    console.log("Loaded recent searches:", recentSearches);

    let searchList = $("#recent-search-list");
    searchList.html("");

    if (recentSearches.length === 0) {
        console.log("No recent searches available.");
        searchList.append("<li>No recent searches found.</li>");
    } else {
        recentSearches.forEach((search, index) => {
            let searchText = [];

            if (search.keyword) searchText.push(`<strong>${search.keyword}</strong>`);
            if (search.city) searchText.push(` ${search.city}`);
            if (search.category) searchText.push(` ${search.category}`);
            if (search.bhk) searchText.push(` ${search.bhk}`);

            if (
                search.minPrice !== undefined && search.maxPrice !== undefined &&
                search.minPrice !== null && search.maxPrice !== null &&
                search.minPrice !== '' && search.maxPrice !== ''
            ) {
                searchText.push(`Price : ₹${search.minPrice} - ₹${search.maxPrice}`);
            }

            if (search.saleType) searchText.push(` ${search.saleType}`);
            if (search.constructionStatus) searchText.push(` ${search.constructionStatus}`);

            if (searchText.length > 0) {
                searchList.append(`
                    <li>
                        ${searchText.join(" | ")}
                    </li>
                `);
            }
        });

        $("#recent-searches-data").show();
    }

    $("#clear-history").click(function() {
        localStorage.removeItem("recentSearches");
        searchList.html("<li>No recent searches found.</li>");
        $("#recent-searches-data").hide();
        console.log("Search history cleared!");
    });

    $(".redo-search").click(function() {
        let index = $(this).data("index");
        let searchData = recentSearches[index];
    });
});

</script>
@endpush
