@extends('layouts.front')
@push('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/css/intlTelInput.css" />
    <style>
        .iti {
            width: 100%;
        }
        .card {
            border-radius: 12px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        .real-estate-agent {
            margin-top: 15px;
        }
        .radio-button {
            accent-color: #007bff;
            transform: scale(1.2);
            margin-right: 10px;
        }
        .radio-label {
            font-weight: bold;
            color: #333;
        }
    </style>
@endpush
@section('content')
    <section class="gray p-1"
        style="background: url('https://images.unsplash.com/photo-1605146769289-440113cc3d00?q=80&w=1470&auto=format&fit=crop&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D') no-repeat center center;
background-size: cover;">
        <div class="container my-5">
            <div class="row justify-content-center">
                <div class="col-md-5">
                    <div class="card p-4 text-dark">
                        <div class="mb-4">
                            <h2 class="fw-bold">@lang('Create Account')</h2>
                        </div>
                        <form id="registerform1" action="{{ route('user.register.submit') }}" method="POST">
                            @csrf
                            <div class="mb-3">
                                <input type="text" name="name" id="name" class="form-control rounded"
                                    placeholder="@lang('Full Name')" required value="{{ old('name') }}">
                                @error('name')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <input type="tel" name="phone" id="phone" class="form-control rounded"
                                    placeholder="Enter Phone Number" value="{{ old('phone', session('phone')) }}"
                                    {{ session('phone') ? 'disabled' : '' }} inputmode="numeric" pattern="[0-9]*">
                                @error('phone')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <input type="email" name="email" class="form-control rounded" placeholder="Enter Your Email"
                                    value="{{ old('email', session('email')) }}" {{ session('email') ? 'disabled' : '' }}>
                                @error('email')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <input type="password" name="password" id="password" class="form-control rounded"
                                    placeholder="@lang('Password')" required>
                                @error('password')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label class="form-label d-block">Are you </label>

                                <div class="form-check ">
                                    <input class="form-check-input" type="radio" name="user_type" id="user"
                                        value="user" {{ old('user_type') == 'user' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="user">Property buyer</label>
                                    <small class="text-sm">( Looking to buy property )</small>
                                </div>

                                <div class="form-check ">
                                    <input class="form-check-input" type="radio" name="user_type" id="tenant"
                                        value="tenant" {{ old('user_type') == 'tenant' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="tenant">Tenant</label>
                                    <small class="text-sm">( Looking to rent or PG | Co-Living )</small>
                                </div>

                                <div class="form-check ">
                                    <input class="form-check-input" type="radio" name="user_type" id="owner"
                                        value="owner" {{ old('user_type') == 'owner' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="owner">Property Owner</label>
                                    <small class="text-sm">( Looking to sell your property )</small>
                                </div>
                                <div class="form-check ">
                                    <input class="form-check-input" type="radio" name="user_type" id="agent"
                                        value="agent" {{ old('user_type') == 'agent' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="agent">Property Agent</label>
                                </div>
                                <div class="form-check ">
                                    <input class="form-check-input" type="radio" name="user_type" id="builder/developer"
                                        value="builder/developer"
                                        {{ old('user_type') == 'builder/developer' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="builder/developer">Builder/Developer</label>
                                </div>
                            </div>
                            <div class="form-check checkbox-label mt-3">
                                <input type="checkbox" class="form-check-input" id="terms" required>
                                <label for="terms" class="form-check-label">
                                    @lang('I agree to the') <a href="#">@lang('Terms & Conditions')</a> @lang('and') <a
                                        href="#">@lang('Privacy Policy')</a>.
                                </label>
                            </div>
                            <div class="mt-4">
                                <button type="submit" class="btn rounded theme-bg w-100">
                                    @lang('Create Account')
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/intlTelInput.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const phoneInput = document.getElementById('phone'); // Get phone input element
            if (phoneInput) {
                try {
                    const iti = intlTelInput(phoneInput, {
                        initialCountry: "in",
                        separateDialCode: true,
                        preferredCountries: ["in", "us", "gb"],
                        utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/utils.js",
                    });
                } catch (error) {
                    console.error('Error initializing intlTelInput:', error);
                }
            }
        });
        document.getElementById('phone').addEventListener('input', function(e) {
            this.value = this.value.replace(/\D/g, ''); // remove all non-digits
        });
        document.addEventListener('DOMContentLoaded', function() {
            const userTypeButtons = document.querySelectorAll('.user-type-btn');
            const userTypeInput = document.getElementById('user_type');

            // ✅ Set active class based on the old value from hidden input
            const selectedType = userTypeInput.value;
            if (selectedType) {
                userTypeButtons.forEach(btn => {
                    if (btn.getAttribute('data-value') === selectedType) {
                        btn.classList.add('theme-bg', 'text-white');
                    }
                });
            }

            // ✅ On button click, update hidden input and active styles
            userTypeButtons.forEach(button => {
                button.addEventListener('click', function() {
                    // Set the value of the hidden input to the selected user type
                    userTypeInput.value = this.getAttribute('data-value');

                    // Remove previous active classes
                    userTypeButtons.forEach(btn => btn.classList.remove('theme-bg', 'text-white'));

                    // Add active class to clicked button
                    this.classList.add('theme-bg', 'text-white');
                });
            });

            // ✅ Validate the user type selection on form submission
            document.getElementById('registerform1').addEventListener('submit', function(e) {
                const userType = userTypeInput.value;
                if (!userType) {
                    e.preventDefault();
                    alert('Please select a user type');
                }
            });
        });
    </script>
@endpush
