@extends('layouts.front')
@section('content')
    <section class="gray"
        style="background: url('https://images.unsplash.com/photo-1605146769289-440113cc3d00?q=80&w=1470&auto=format&fit=crop&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D') no-repeat center center;
background-size: cover;">
        <div class="container my-5">
            <div class="row justify-content-center">
                <div class="col-md-5">
                    <div class="card p-4">
                        <div class="text-white text-center mb-2 mt-2">
                            <h3>@lang('Verify OTP')</h3>
                        </div>
                        <div class="card-body">
                            @if (session('phone'))
                                <div class="alert alert-success text-center" role="alert">
                                    @lang('4-digit OTP has been sent to your phone number:') <strong>{{ session('phone') }}</strong>
                                </div>
                            @endif
                            <form id="verify-otp-form" action="{{ route('user.otp.verify.submit') }}" method="POST">
                                @csrf
                                <div class="form-group mb-4">
                                    <label for="otp" class="form-label">@lang('Enter the 4-digit OTP sent to your phone')</label>
                                    <input type="text" name="otp" id="otp" class="form-control rounded"
                                        placeholder="Enter OTP" maxlength="4" minlength="4" aria-label="OTP">
                                </div>
                                <div class="form-group text-center mb-3">
                                    <p id="resend-otp-message" class="mb-0 text-muted">
                                        @lang('Resend OTP in') <span id="countdown">90</span> @lang('seconds').
                                    </p>
                                    <a href="" id="resend-otp-btn" class="text-success d-none"
                                        onclick="regenerateOtp()">
                                        @lang('Resend OTP')
                                    </a>
                                </div>
                                <div class="form-group text-center">
                                    <button type="submit" class="btn rounded theme-bg w-100">
                                        @lang('Verify OTP or Login')
                                    </button>
                                </div> <br>
                                OR
                                <div class="form-group mt-3 mb-4">
                                    <input type="password" name="password" id="password" class="form-control rounded"
                                        placeholder="Enter Password" aria-label="Password">
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@push('js')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const resendOtpMessage = document.getElementById('resend-otp-message');
            const resendOtpBtn = document.getElementById('resend-otp-btn');
            const countdownElement = document.getElementById('countdown');
            const countdownDuration = 90; // 1.5 minutes in seconds
            let timerInterval;
            // Format time as 'X min Y sec'
            const formatTime = (time) => {
                const minutes = Math.floor(time / 60);
                const seconds = time % 60;
                return `${minutes} min ${seconds.toString().padStart(2, '0')} sec`;
            };
            // Start the countdown timer
            const startTimer = (endTime) => {
                clearInterval(timerInterval); // Clear any previous interval
                const updateTimer = () => {
                    const remainingTime = Math.max(0, Math.floor((endTime - Date.now()) / 1000));
                    countdownElement.textContent = formatTime(remainingTime); // Update the timer text
                    if (remainingTime > 0) {
                        resendOtpMessage.classList.remove('d-none');
                        resendOtpBtn.classList.add('d-none');
                    } else {
                        resendOtpMessage.classList.add('d-none');
                        resendOtpBtn.classList.remove('d-none');
                        clearInterval(timerInterval); // Stop the timer when finished
                    }
                };
                timerInterval = setInterval(updateTimer, 1000);
                updateTimer(); // Call immediately to avoid 1-second delay
            };
            const initializeTimer = () => {
                const endTime = Date.now() + countdownDuration * 1000; // Set a new end time
                startTimer(endTime);
            };
            initializeTimer(); // Initialize when the page loads
            // Handle OTP resend
            window.regenerateOtp = function(event) {
                event.preventDefault(); // Prevent button default behavior
                fetch('{{ route('user.otp.regenerate') }}', {
                        method: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': '{{ csrf_token() }}',
                            'Content-Type': 'application/json',
                        },
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            alert('OTP has been resent successfully.');
                            initializeTimer(); // Reset the timer
                        } else {
                            alert('Error: Unable to resend OTP.');
                        }
                    })
                    .catch(error => {
                        console.error('Error resending OTP:', error);
                    });
            };
            // Clear timer on OTP verification
            const otpForm = document.getElementById('verify-otp-form');
            if (otpForm) {
                otpForm.addEventListener('submit', function() {
                    clearInterval(timerInterval); // Stop the timer
                });
            }
        });
    </script>
@endpush
