<?php
use App\Models\Location;
use App\Http\Controllers;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Agent\PlanController;
use App\Http\Controllers\Agent\AgentController;
use App\Http\Controllers\Agent\LoginController;
use App\Http\Controllers\Agent\OrderController;
use App\Http\Controllers\Agent\InvestController;
use App\Http\Controllers\Agent\GalleryController;
use App\Http\Controllers\Agent\PropertyController;
use App\Http\Controllers\Agent\RegisterController;
use App\Http\Controllers\Agent\ScheduleController;
use App\Http\Controllers\Agent\FloorPlanController;
use App\Http\Controllers\Agent\DynamicFormController;
use App\Http\Controllers\Agent\CrowdfundingController;
use App\Http\Controllers\Agent\InvestPropertyController;
use App\Http\Controllers\Agent\PropertyEnquiryController;
use App\Http\Controllers\Agent\PropertyContractController;

Route::prefix('agent')->group(function () {
    Route::get('/dashboard', [AgentController::class, 'index'])->name('agent.dashboard');
    // veloxinfra updated code
    Route::get('/floor-plan/datatables/{pid}', [FloorPlanController::class, 'datatables'])->name('agent.floor.plan.datatables');
    Route::get('/floor-plan/{pid}', [FloorPlanController::class, 'index'])->name('agent.floor.plan.index');
    Route::get('/floor-plan/create/{pid}', [FloorPlanController::class, 'create'])->name('agent.floor.plan.create');
    Route::get('/floor-plan/edit/{id}/{pid}', [FloorPlanController::class, 'edit'])->name('agent.floor.plan.edit');
    Route::post('/floor-plan/store/{pid}', [FloorPlanController::class, 'store'])->name('agent.floor.plan.store');
    Route::post('/floor-plan/update/{id}/{pid}', [FloorPlanController::class, 'update'])->name('agent.floor.plan.update');
    Route::get('/floor-plan/delete/{id}/{pid}', [FloorPlanController::class, 'destroy'])->name('agent.floor.plan.delete');


    Route::group(['middleware' => 'authagent'], function () {
        Route::get('/profile', [AgentController::class, 'profile'])->name('agent.profile');
        Route::post('/profile/update', [AgentController::class, 'profileupdate'])->name('agent.profile.update');

        Route::get('/password', [AgentController::class, 'passwordreset'])->name('agent.password');
        Route::post('/password/update', [AgentController::class, 'changepass'])->name('agent.password.update');

        Route::get('/invest/properties/datatables', [InvestPropertyController::class, 'datatables'])->name('agent.invest.properties.datatables');
        Route::get('/invest/properties', [InvestPropertyController::class, 'index'])->name('agent.invest.properties.index');
        Route::get('/invest/properties/create', [InvestPropertyController::class, 'create'])->name('agent.invest.properties.create');
        Route::get('/invest/properties/edit/{id}', [InvestPropertyController::class, 'edit'])->name('agent.invest.properties.edit');
        Route::post('/invest/properties/store', [InvestPropertyController::class, 'store'])->name('agent.invest.properties.store');
        Route::get('/invest/properties/status/{id1}/{id2}', [InvestPropertyController::class, 'status'])->name('agent.invest.properties.status');
        Route::post('/invest/properties/update/{id}', [InvestPropertyController::class, 'update'])->name('agent.invest.properties.update');
        Route::get('/invest/properties/delete/{id}', [InvestPropertyController::class, 'destroy'])->name('agent.invest.properties.delete');

        Route::get('/properties/datatables', [PropertyController::class, 'datatables'])->name('agent.properties.datatables');
        Route::get('/properties', [PropertyController::class, 'index'])->name('agent.properties.index');
        Route::get('/properties/pending', [PropertyController::class, 'pending'])->name('agent.properties.pending');
        Route::get('/properties/approved', [PropertyController::class, 'approved'])->name('agent.properties.approved');

        Route::get('/properties/step-1/{id?}', [PropertyController::class, 'step_1'])->name('agent.properties.step_1');
        Route::post('/properties/step-1/{id?}', [PropertyController::class, 'store_1'])->name('agent.properties.store_1');

        Route::get('/properties/step-2/{id?}', [PropertyController::class, 'step_2'])->name('agent.properties.step_2');
        Route::post('/properties/step-resi-rent/{id?}', [PropertyController::class, 'store_resi_rent'])->name('agent.properties.store_resi_rent');
        Route::post('/properties/step-comm-rent/{id?}', [PropertyController::class, 'store_comm_rent'])->name('agent.properties.store_comm_rent');
        Route::post('/properties/step-plot-rent/{id?}', [PropertyController::class, 'store_plot_rent'])->name('agent.properties.store_plot_rent');

        Route::post('/properties/step-plots/{id?}', [PropertyController::class, 'store_plots'])->name('agent.properties.store_plots');
        Route::post('/properties/step-flats/{id?}', [PropertyController::class, 'store_flats'])->name('agent.properties.store_flats');
        Route::post('/properties/step-office/{id?}', [PropertyController::class, 'store_office'])->name('agent.properties.store_office');
        Route::post('/properties/step-storage/{id?}', [PropertyController::class, 'store_storage'])->name('agent.properties.store_storage');
        Route::post('/properties/step-retail/{id?}', [PropertyController::class, 'store_retail'])->name('agent.properties.store_retail');
        Route::post('/properties/step-plot/{id?}', [PropertyController::class, 'store_plot'])->name('agent.properties.store_plot');
        Route::post('/properties/step-other/{id?}', [PropertyController::class, 'store_other'])->name('agent.properties.store_other');
        Route::post('/properties/step-hospitality/{id?}', [PropertyController::class, 'store_hospitality'])->name('agent.properties.store_hospitality');

        Route::get('/properties/step-3/{id?}', [PropertyController::class, 'step_3'])->name('agent.properties.step_3');
        Route::post('/properties/step-3/{id?}', [PropertyController::class, 'store_step_3'])->name('agent.properties.store_step_3');

        Route::get('/properties/step-4/{id?}', [PropertyController::class, 'step_4'])->name('agent.properties.step_4');
        Route::post('/properties/step-4/{id?}', [PropertyController::class, 'store_step_4'])->name('agent.properties.store_step_4');
        Route::post('/properties/rent-step-4/{id?}', [PropertyController::class, 'rent_store_step_4'])->name('agent.properties.rent_store_step_4');

        Route::get('/properties/edit/{id}', [PropertyController::class, 'edit'])->name('agent.properties.edit');
        Route::post('/properties/update/{id}', [PropertyController::class, 'update'])->name('agent.properties.update');
        Route::get('/properties/delete/{id}', [PropertyController::class, 'destroy'])->name('agent.properties.delete');

        Route::get('/schedules', [ScheduleController::class, 'index'])->name('agent.schedules.index');
        Route::post('/schedules', [ScheduleController::class, 'update'])->name('agent.schedules.update');

        Route::get('/contracts/datatables/{type}', [PropertyContractController::class, 'datatables'])->name('agent.property.contracts.datatables');
        Route::get('/property-contracts/rents', [PropertyContractController::class, 'rents'])->name('agent.property.contracts.rents');
        Route::get('/property-contracts/sells', [PropertyContractController::class, 'sells'])->name('agent.property.contracts.sells');
        Route::get('/property-contracts/{slug}', [PropertyContractController::class, 'details'])->name('agent.property.contracts.details');
        Route::get('/contract-paper/{id}', [PropertyContractController::class, 'contractPaper'])->name('agent.property.contract.paper');
        Route::get('/property-contracts/status/{id1}/{id2}', [PropertyContractController::class, 'status'])->name('agent.property.contracts.status');
        Route::get('/property-phase/status/{id1}/{id2}', [PropertyContractController::class, 'phase'])->name('agent.property.contracts.phase');

        Route::get('/property/orders/datatables', [OrderController::class, 'datatables'])->name('agent.property.order.datatables');
        Route::get('/property/order', [OrderController::class, 'index'])->name('agent.property.order.index');

        Route::get('/gallery/show', [GalleryController::class, 'show'])->name('agent.gallery.show');
        Route::post('/gallery/store', [GalleryController::class, 'store'])->name('agent.gallery.store');
        Route::get('/gallery/delete', [GalleryController::class, 'destroy'])->name('agent.gallery.delete');

        Route::get('/invests/datatables', [InvestController::class, 'datatables'])->name('agent.invests.datatables');
        Route::get('/invests', [InvestController::class, 'index'])->name('agent.invests.index');
        Route::get('/invests/status/{id1}/{id2}', [InvestController::class, 'status'])->name('agent.invests.status');
        Route::get('/invests/{id}/show', [InvestController::class, 'investdetails'])->name('agent.invests.show');

        Route::get('/dynamic-form', [DynamicFormController::class, 'create'])->name('agent.dynamic.from.create');
        Route::post('/dynamic-form', [DynamicFormController::class, 'store'])->name('agent.dynamic.from.store');
        Route::post('/dynamic-form/update', [DynamicFormController::class, 'update'])->name('agent.dynamic.form.update');
        Route::post('/dynamic-form/delete', [DynamicFormController::class, 'deletedField'])->name('agent.dynamic.form.delete');

        Route::get('/enquiries/datatables', [PropertyEnquiryController::class, 'datatables'])->name('agent.properties.enquiries.datatables');
        Route::get('/property-enquiries', [PropertyEnquiryController::class, 'index'])->name('agent.properties.enquiries.index');

        Route::get('/packages/all/', [PlanController::class, 'userAllPackages'])->name('agent.packages.all');
        Route::get('/packages/active/', [PlanController::class, 'userActivePackages'])->name('agent.packages.active');
        Route::get('/packages/credit', [PlanController::class, 'userCredit'])->name('agent.packages.credit');
        Route::get('/packages/expired', [PlanController::class, 'userExpiredPackages'])->name('agent.packages.expired');
    });

});
