<?php

use App\Http\Controllers;
use App\Jobs\SendEmailJob;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Frontend\PgController;
use App\Http\Controllers\User\ForgotController;
use App\Http\Controllers\Frontend\BuyController;
use App\Http\Controllers\Frontend\RentController;
use App\Http\Controllers\Frontend\DommyController;
use App\Http\Controllers\Frontend\InvestController;
use App\Http\Controllers\User\VerifyEmailController;
use App\Http\Controllers\Frontend\FrontendController;
use App\Http\Controllers\Frontend\PropertyController;
use App\Http\Controllers\Frontend\CommercialController;
use Illuminate\Foundation\Auth\EmailVerificationRequest;
use App\Http\Controllers\User\EmailVerificationPromptController;
use App\Http\Controllers\User\LoginController as UserLoginController;
use App\Http\Controllers\User\EmailVerificationNotificationController;
use App\Http\Controllers\User\RegisterController as UserRegisterController;
use App\Http\Controllers\Agent\PropertyController as AgentPropertyController;
use App\Http\Controllers\Agent\RegisterController as AgentRegisterController;
use App\Http\Controllers\Frontend\PlotController;

Route::redirect('admin', 'admin/login');
Route::post('the/genius/ocean/2441139', [FrontendController::class, 'subscription']);
Route::get('finalize', [FrontendController::class, 'finalize']);

Route::get('/under-maintenance', [FrontendController::class, 'maintenance'])->name('front-maintenance');

Route::get('verify-email', EmailVerificationPromptController::class)
  ->name('verification.notice');

Route::get('verify-email/{id}/{hash}', [VerifyEmailController::class, 'verify'])
  ->middleware(['signed', 'throttle:6,1'])
  ->name('verification.verify');

Route::post('email/verification-notification', [EmailVerificationNotificationController::class, 'store'])
  ->middleware('throttle:6,1')
  ->name('verification.send');

Route::group(['middleware' => 'maintenance'], function () {

  Route::get('/', [FrontendController::class, 'index'])->name('front.index');
  Route::get('/search-suggestions', [FrontendController::class, 'searchSuggestions'])->name('front.search-suggestions');
  
  Route::get('/buy-real-estate-{location_name}', [BuyController::class, 'index'])->name('front.index.location');

  Route::post('/set-city-session', function (Illuminate\Http\Request $request) {
    session(['selected_city' => $request->city]);
    return response()->json(['status' => 'ok']);
  })->name('set.city.session');

 Route::prefix('in')->group(function () {
    // -----------------
    // Buy module
    // -----------------
    
    Route::get('/buy/real-estate-in-{locality?}-in-{city?}', [BuyController::class, 'search'])
        ->where([
            'locality' => '[A-Za-z0-9\-]+', // allow letters, numbers, and hyphens
        ])
        ->name('buy.search');

    Route::get('/buy/real-estate-in-{city}', [BuyController::class, 'index'])
        ->name('buy.index.location');
      
    Route::get('/buy/real-estate/{slug}', [BuyController::class, 'details'])
        ->name('buy.details');

    // Route::get('/buy/get-suggestions', [BuyController::class, 'getSuggestions'])
    //     ->name('buy.getSuggestions');
        
    // Route::get('/buy/buy-suggestions', [BuyController::class, 'getSuggestions'])
    //     ->name('buy.Suggestions');

    // -----------------
    // Rent module
    // -----------------

    Route::get('/rent/property-for-rent-in-{locality?}-in-{city?}', [RentController::class, 'search'])
        ->where([
                'locality' => '[A-Za-z0-9\-]+', // allow letters, numbers, and hyphens
            ])
        ->name('rent.search');

    Route::get('/rent/property-for-rent-in-{city}', [RentController::class, 'index'])
        ->name('rent.index.location');

    Route::get('/rent/property-for-rent/{slug}', [RentController::class, 'details'])
        ->name('rent.details');

    // -----------------
    // Commercial module
    // -----------------
    
    Route::get('/commercial/buy/commercial-property-for-sale-in-{locality?}-in-{city?}', [CommercialController::class, 'buySearch'])
    ->where([
            'locality' => '[A-Za-z0-9\-]+', // allow letters, numbers, and hyphens
        ])    
    ->name('commercial.buysearch');

    Route::get('/commercial/rent/commercial-property-for-rent-in-{locality?}-in-{city?}', [CommercialController::class, 'leaseSearch'])
    ->where([
            'locality' => '[A-Za-z0-9\-]+', // allow letters, numbers, and hyphens
        ])      
    ->name('commercial.leasesearch');
        
    Route::get('/commercial/commercial-real-estate-in-{city}', [CommercialController::class, 'index'])
        ->name('commercial.index.location');


    Route::get('/commercial/commercial-real-estate/{slug}', [CommercialController::class, 'details'])
        ->name('commercial.details');

    // -----------------
    // PG/Co-living module
    // -----------------
     Route::get('/paying-guests/pgs-in-{locality?}-in-{city?}', [PgController::class, 'search'])
     ->where([
            'locality' => '[A-Za-z0-9\-]+', // allow letters, numbers, and hyphens
        ])
        ->name('pg.search');

    Route::get('/paying-guests/pgs-in-{city}', [PgController::class, 'index'])
        ->name('pg.index.location');

    Route::get('/paying-guests/pgs/{slug}', [PgController::class, 'details'])
        ->name('pg.details');

    // -----------------
    // Plot module
    // -----------------
    
    Route::get('/plots/buy-plot-in-{locality?}-in-{city?}', [PlotController::class, 'search'])
        ->where([
                'locality' => '[A-Za-z0-9\-]+', // allow letters, numbers, and hyphens
            ])
        ->name('plot.search');

    Route::get('/plots/buy-plot-in-{city}', [PlotController::class, 'index'])
        ->name('plot.index.location');


    Route::get('/plots/{slug}', [PlotController::class, 'details'])
        ->name('plot.details');
});


  // routes for agent
  Route::get('/post-property', [AgentRegisterController::class, 'otpForm'])->name('agent.agent-step-1');
  Route::post('/post-property-otp', [AgentRegisterController::class, 'sendOtp'])->name('agent.send.otp');

  Route::get('/post-property-email', [AgentRegisterController::class, 'emailForm'])->name('agent.by.email');
  Route::post('/post-property-email', [AgentRegisterController::class, 'emailSubmit'])->name('agent.email.submit');

  Route::get('/post-property-password', [AgentRegisterController::class, 'passwordForm'])->name('agent.login-with-password');
  Route::post('/post-property-password', [AgentRegisterController::class, 'passwordSubmit'])->name('agent.pass.submit');

  Route::get('/post-property-verify', [AgentRegisterController::class, 'verifyOtpform'])->name('agent.verify.otp');
  Route::post('/post-property-verify', [AgentRegisterController::class, 'verifyOtp'])->name('agent.otp.verify.submit');
  Route::post('/post-property-resend-otp', [AgentRegisterController::class, 'regenerateOtp'])->name('agent.otp.regenerate');

  Route::get('/post-property-step-2', [AgentRegisterController::class, 'showRegister'])->name('agent.register-step-2');
  Route::post('/post-property-register-submit', [AgentRegisterController::class, 'register'])->name('agent.register.submit');
  Route::get('/post-property-register/verify/{token}', [AgentRegisterController::class, 'token'])->name('agent.register.token');

  // routes for comman 

  Route::get('/forgot', [ForgotController::class, 'showforgotform'])->name('user.forgot');
  Route::post('/forgot', [ForgotController::class, 'forgot'])->name('user.forgot.submit');

  // routes for customer 

  Route::get('/login-register', [UserRegisterController::class, 'otpForm'])->name('user.otp');
  Route::post('/login-register-otp', [UserRegisterController::class, 'sendOtp'])->name('user.send.otp');

  Route::get('/login-register-verify', [UserRegisterController::class, 'verifyOtpform'])->name('user.verify.otp');
  Route::post('/login-register-verify', [UserRegisterController::class, 'verifyOtp'])->name('user.otp.verify.submit');
  Route::post('/login-register-resend-otp', [UserRegisterController::class, 'regenerateOtp'])->name('user.otp.regenerate');

  Route::get('/login-register-email', [UserRegisterController::class, 'emailForm'])->name('user.by.email');
  Route::post('/login-register-email', [UserRegisterController::class, 'emailSubmit'])->name('user.email.submit');

  Route::get('/login-register-password', [UserRegisterController::class, 'passwordForm'])->name('user.login-with-password');
  Route::post('/login-register-password', [UserRegisterController::class, 'passwordSubmit'])->name('user.pass.submit');

  Route::get('/login-register-step-2', [UserRegisterController::class, 'showRegisterForm'])->name('user.register-step-2');
  Route::post('/login-register-submit', [UserRegisterController::class, 'register'])->name('user.register.submit');
  Route::get('/login-register-verify-token/{token}', [UserRegisterController::class, 'token'])->name('user.register.token');


  Route::get('get-suggestions', [PropertyController::class, 'getSuggestions'])->name('front.getSuggestions');
  //   Route::get('/listing', [PropertyController::class, 'listing'])->name('front.listing');
  //   Route::get('/property/{slug}', [PropertyController::class, 'propertyDetails'])->name('front.property.details');
  Route::get('/property-create', [PropertyController::class, 'create'])->name('front.property.create');
  Route::post('/property/wishlist', [PropertyController::class, 'wishlist'])->name('front.property.wishlist');
  Route::get('/agents', [PropertyController::class, 'agents'])->name('front.agents');
  Route::get('/agents/{id}', [PropertyController::class, 'agentDetails'])->name('front.agent.details');

  Route::post('/property/save-property', [PropertyController::class, 'saveProperty'])->middleware('auth');

  Route::get('/invest-properties', [InvestController::class, 'invests'])->name('front.invests');
  Route::get('blogs', [FrontendController::class, 'blog'])->name('front.blog');
  Route::get('blog/{slug}', [FrontendController::class, 'blogdetails'])->name('blog.details');
  Route::get('/blog-search', [FrontendController::class, 'blogsearch'])->name('front.blogsearch');
  Route::get('/blog/category/{slug}', [FrontendController::class, 'blogcategory'])->name('front.blogcategory');
  Route::get('/blog/tag/{slug}', [FrontendController::class, 'blogtags'])->name('front.blogtags');
  Route::get('/blog/archive/{slug}', [FrontendController::class, 'blogarchive'])->name('front.blogarchive');

  Route::get('/plans', [FrontendController::class, 'plans'])->name('front.plans');

  Route::get('/contact', [FrontendController::class, 'contact'])->name('front.contact');
  Route::post('/contact', [FrontendController::class, 'contactemail'])->name('front.contact.submit');
  Route::get('/faq', [FrontendController::class, 'faq'])->name('front.faq');
  Route::get('/{slug}', [FrontendController::class, 'page'])->name('front.page');
  Route::post('/subscriber', [FrontendController::class, 'subscriber'])->name('front.subscriber');

  Route::get('/currency/{id}', [FrontendController::class, 'currency'])->name('front.currency');
  Route::get('/language/{id}', [FrontendController::class, 'language'])->name('front.language');

  Route::get('/signup-session/flus', [FrontendController::class, 'signupSession'])->name('front.signup.session');
});
Route::get('/profit/send', [FrontendController::class, 'profitSend'])->name('front.profit.send');
